/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.event;

import com.magistuarmory.EpicKnights;
import com.magistuarmory.item.MedievalShieldItem;
import com.magistuarmory.item.MedievalWeaponItem;
import com.magistuarmory.misc.ModLoot;
import com.magistuarmory.misc.ModMerchOffers;
import com.magistuarmory.util.MobEquipment;
import com.magistuarmory.util.MobEquipmentHelper;
import com.magistuarmory.util.ModDamageSources;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.LootEvent;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class CommonEvents {
    public static void init() {
        LootEvent.MODIFY_LOOT_TABLE.register(CommonEvents::onModifyLootTable);
        LifecycleEvent.SETUP.register(CommonEvents::onSetup);
        LifecycleEvent.SERVER_STARTING.register(CommonEvents::onServerStarting);
        LifecycleEvent.SERVER_LEVEL_LOAD.register(CommonEvents::onServerLevelLoad);
        EntityEvent.ADD.register(CommonEvents::onEntityJoinLevel);
        EntityEvent.LIVING_HURT.register(CommonEvents::onLivingHurt);
    }

    public static void onModifyLootTable(class_5321<class_52> key, LootEvent.LootTableModificationContext context, boolean builtin) {
        ModLoot.modifyLootTable(key, context, builtin);
    }

    public static void onSetup() {
        ModMerchOffers.setup();
    }

    public static void onServerStarting(MinecraftServer server) {
        MobEquipment.setup(server);
        EpicKnights.checkBetterCombatOrEpicFightInstalled();
    }

    public static void onServerLevelLoad(class_1937 level) {
        ModDamageSources.setup(level.method_30349());
    }

    public static EventResult onEntityJoinLevel(class_1297 entity, class_1937 level) {
        if (entity instanceof class_1309) {
            class_1309 livingentity = (class_1309)entity;
            MobEquipmentHelper.equip(livingentity);
        }
        return EventResult.pass();
    }

    public static EventResult onLivingHurt(class_1309 victim, class_1282 source, float damage) {
        class_1309 attacker;
        class_1792 class_17922;
        class_1657 player;
        if (victim.method_37908().method_8608()) {
            return EventResult.pass();
        }
        class_1799 stack = victim.method_6030();
        if (victim.method_5655() || victim instanceof class_1657 && (player = (class_1657)victim).method_7337()) {
            return EventResult.pass();
        }
        if (victim.method_6039()) {
            MedievalWeaponItem weapon;
            class_17922 = stack.method_7909();
            if (class_17922 instanceof MedievalShieldItem) {
                MedievalShieldItem shield = (MedievalShieldItem)class_17922;
                shield.onBlocked(stack, damage, victim, source);
                return EventResult.pass();
            }
            class_17922 = stack.method_7909();
            if (class_17922 instanceof MedievalWeaponItem && (weapon = (MedievalWeaponItem)class_17922).canBlock()) {
                weapon.onBlocked(stack, damage, victim, source);
                return EventResult.pass();
            }
        }
        if ((class_17922 = source.method_5529()) instanceof class_1309 && (class_17922 = (attacker = (class_1309)class_17922).method_6047().method_7909()) instanceof MedievalWeaponItem) {
            MedievalWeaponItem weapon2 = (MedievalWeaponItem)class_17922;
            weapon2.onHurtEntity(source, victim, damage);
        }
        return EventResult.pass();
    }
}

