/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.magistuarmory.EpicKnights;
import com.magistuarmory.client.HitResultHelper;
import com.magistuarmory.component.ModDataComponents;
import com.magistuarmory.item.MedievalWeaponItem;
import com.magistuarmory.item.ModItemTier;
import com.magistuarmory.item.ModItems;
import com.magistuarmory.item.WeaponType;
import com.magistuarmory.network.PacketLanceCollision;
import com.magistuarmory.util.CombatHelper;
import com.magistuarmory.util.ModDamageSources;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1498;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_9331;

public class LanceItem
extends MedievalWeaponItem {
    private final ModItemTier material;
    private List<class_1799> dropItems = new ArrayList<class_1799>();
    protected int clickedticks = 0;
    static int CLICKED_TICKS_COOLDOWN = 5;

    public LanceItem(class_1792.class_1793 properties, ModItemTier material, WeaponType type) {
        super(properties, material, type);
        this.material = material;
    }

    public void resetClickedTicks() {
        this.clickedticks = CLICKED_TICKS_COOLDOWN;
    }

    public float getClickedScale() {
        return class_3532.method_15363((float)((float)this.clickedticks / (float)CLICKED_TICKS_COOLDOWN), (float)0.0f, (float)1.0f);
    }

    public void setupDropItems() {
        String materialname;
        this.dropItems.add(new class_1799((class_1935)class_1802.field_8600, 2));
        switch (materialname = this.material.getMaterialName()) {
            case "iron": {
                this.dropItems.add(new class_1799((class_1935)class_1802.field_8620));
                break;
            }
            case "gold": {
                this.dropItems.add(new class_1799((class_1935)class_1802.field_8695));
                break;
            }
            case "diamond": {
                this.dropItems.add(new class_1799((class_1935)class_1802.field_8477));
                break;
            }
            case "netherite": {
                this.dropItems.add(new class_1799((class_1935)class_1802.field_22020));
                this.dropItems.add(new class_1799((class_1935)class_1802.field_8477));
                break;
            }
            case "steel": {
                this.dropItems.add(new class_1799((class_1935)ModItems.STEEL_INGOT.get()));
            }
        }
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        this.setRaised((class_1309)player, !this.isRaised((class_1309)player));
        return super.method_7836(level, player, hand);
    }

    @Override
    public boolean onAttackClickEntity(class_1799 stack, class_1657 player, class_1297 entity) {
        if (EpicKnights.GENERAL_CONFIG.disableLanceCollision) {
            return super.onAttackClickEntity(stack, player, entity);
        }
        if (player.method_5765() && !this.isRaised((class_1309)player) && !player.method_7357().method_7904((class_1792)this)) {
            this.resetClickedTicks();
        }
        player.method_6104(class_1268.field_5808);
        return false;
    }

    public void collide(class_1657 player, class_1309 victim, class_1937 level) {
        if (player == null || level == null) {
            return;
        }
        if (!this.isRaised((class_1309)player) && !player.method_7357().method_7904((class_1792)this) && player.method_5765()) {
            float speed = this.getVelocityProjection((class_1297)player);
            if (player.method_5668() instanceof class_1498 && (double)speed >= ((class_1498)player.method_5668()).method_5996(class_5134.field_23719).method_6194() || !(player.method_5668() instanceof class_1498) && (double)speed >= 0.233) {
                PacketLanceCollision.sendToServer((class_1297)player, (class_1297)victim);
                player.method_7350();
            }
        }
    }

    @Override
    public boolean onHurtEntity(class_1282 source, class_1309 victim, float damage) {
        class_1297 class_12972;
        if (EpicKnights.GENERAL_CONFIG.disableLanceCollision) {
            return super.onHurtEntity(source, victim, damage);
        }
        if (victim.method_37908().method_8608() || ModDamageSources.isAdditional(source) || !((class_12972 = source.method_5529()) instanceof class_1309)) {
            return true;
        }
        class_1309 attacker = (class_1309)class_12972;
        float speed = 0.0f;
        float bonusdamage = 0.0f;
        boolean dismount = false;
        if (attacker instanceof class_1308) {
            class_1308 mob = (class_1308)attacker;
            class_1799 stack = mob.method_6047();
            speed = this.getRideSpeed(stack);
            this.setRideSpeed(stack, 0.0f);
            bonusdamage = this.calcBonusDamage((class_1297)attacker, speed);
            dismount = this.getDismount(stack);
            this.setDismount(stack, false);
        } else if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            class_1799 stack = player.method_6047();
            speed = this.getRideSpeed(stack);
            this.setRideSpeed(stack, 0.0f);
            bonusdamage = this.calcBonusDamage((class_1297)attacker, speed);
            dismount = this.getDismount(stack);
            this.setDismount(stack, false);
            if (stack.method_7919() >= stack.method_7936() - 1) {
                this.onBroken(player);
            }
            if (stack.method_7919() >= stack.method_7936() - 1) {
                this.onBroken(player);
            } else if (!player.method_7337()) {
                if ((float)victim.method_6096() >= 9.0f * (this.material.method_8028() + 1.0f) || victim.method_6039()) {
                    stack.method_7974(stack.method_7919() + (int)((0.6 + (double)(bonusdamage / 20.0f)) * victim.method_37908().method_8409().method_43058() * (double)stack.method_7936()));
                } else {
                    stack.method_7974(stack.method_7919() + 1);
                }
            }
            for (class_1799 stack0 : player.method_31548().field_7547) {
                this.setRaised((class_1309)player, true);
                player.method_7357().method_7906(stack0.method_7909(), (int)player.method_7279());
            }
            if (stack.method_7919() >= stack.method_7936()) {
                this.onBroken(player);
                stack.method_7939(0);
            }
        }
        class_243 vec = attacker.method_5828(1.0f);
        double magnitude = Math.min(1.0f, speed * this.getTotalMass((class_1297)attacker) / this.getTotalMass((class_1297)victim));
        class_243 vel = vec.method_18805(magnitude, magnitude, magnitude);
        if (victim.method_5765()) {
            victim.method_5668().method_18799(victim.method_5668().method_18798().method_1019(vel));
            victim.method_5668().field_6007 = true;
            if (dismount) {
                victim.method_5848();
            }
        } else {
            victim.method_18799(victim.method_18798().method_1019(vel));
            victim.field_6007 = true;
        }
        if (!super.onHurtEntity(source, victim, bonusdamage + damage) && bonusdamage != 0.0f) {
            victim.method_5643(ModDamageSources.additional((class_1297)attacker), bonusdamage + damage);
            return true;
        }
        return false;
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int i, boolean selected) {
        if (EpicKnights.GENERAL_CONFIG.disableLanceCollision) {
            super.method_7888(stack, level, entity, i, selected);
            return;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (level.field_9236 && player.method_6047().method_7909() instanceof LanceItem) {
                class_239 hit = HitResultHelper.getMouseOver(class_310.method_1551(), CombatHelper.getAttackReach(player, this));
                if (hit instanceof class_3966) {
                    class_3966 entityhit = (class_3966)hit;
                    class_1297 victim = entityhit.method_17782();
                    if (player.method_5765() && victim instanceof class_1309 && victim.method_5805() && victim.method_5628() != player.method_5854().method_5628()) {
                        this.collide(player, (class_1309)victim, level);
                    }
                }
                if (this.clickedticks > 0) {
                    --this.clickedticks;
                }
            }
            if (!this.isRaised((class_1309)player) && player.method_7357().method_7904((class_1792)this)) {
                this.setRaised((class_1309)player, true);
            }
        }
        super.method_7888(stack, level, entity, i, selected);
    }

    public class_1269 method_7884(class_1838 context) {
        return class_1269.field_5811;
    }

    public float calcBonusDamage(class_1297 entity, float speed) {
        float bonusdamage = 3.0f * this.getTotalMass(entity) * speed;
        return Math.min(Math.max(0.0f, bonusdamage), 0.7f * this.attackDamage);
    }

    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 flag) {
        tooltip.add((class_2561)class_2561.method_43471((String)"lance.rideronly").method_27692(class_124.field_1078));
        tooltip.add((class_2561)class_2561.method_43471((String)"lance.leftclick").method_27692(class_124.field_1078));
        tooltip.add((class_2561)class_2561.method_43471((String)"lance.bonusdamage").method_27692(class_124.field_1078));
        super.method_7851(stack, tooltipContext, tooltip, flag);
    }

    public float getVelocityProjection(class_1297 entity) {
        class_243 velocity = entity.method_5765() ? entity.method_5668().method_18798() : entity.method_18798();
        class_243 vec = entity.method_5828(1.0f);
        if (vec.method_1027() == 0.0) {
            return 0.0f;
        }
        return (float)(velocity.method_1026(vec) / vec.method_1033());
    }

    public float getTotalMass(class_1297 entity) {
        float totalmass = this.getMass(entity);
        class_1297 entity2 = entity;
        while (entity2.method_5765()) {
            entity2 = entity2.method_5854();
            totalmass += this.getMass(entity2);
        }
        for (class_1297 passenger : entity.method_5685()) {
            totalmass += this.getMass(passenger);
        }
        return totalmass;
    }

    public float getMass(class_1297 entity) {
        float mass = 0.0f;
        class_238 box = entity.method_5829();
        mass = (float)((double)mass + box.method_17939() * box.method_17940() * box.method_17941());
        if (entity instanceof class_1309) {
            class_1309 livingentity = (class_1309)entity;
            for (class_1799 armorpiece : livingentity.method_5661()) {
                if (armorpiece.method_7960() || !(armorpiece.method_7909() instanceof class_1738)) continue;
                mass = (float)((double)mass + (double)((float)((class_1738)armorpiece.method_7909()).method_7687() + ((class_1738)armorpiece.method_7909()).method_26353()) / 20.0);
            }
        }
        return mass;
    }

    public void onBroken(class_1657 player) {
        if (player.method_6047().method_7909() == this) {
            for (class_1799 stack : this.dropItems) {
                player.method_7328(stack, true);
            }
            player.method_5783(class_3417.field_15075, 1.0f, 1.0f);
        }
    }

    public boolean isRaised(@Nullable class_1309 entity) {
        if (entity == null) {
            return false;
        }
        class_1799 stack = entity.method_6047();
        Integer raised = (Integer)stack.method_57824((class_9331)ModDataComponents.RAISED.get());
        return raised != null && raised == 1;
    }

    public void setRaised(class_1309 entity, boolean raised) {
        class_1799 stack = entity.method_6047();
        stack.method_57379((class_9331)ModDataComponents.RAISED.get(), (Object)(raised ? 1 : 0));
    }

    public boolean getDismount(class_1799 stack) {
        Boolean dismount = (Boolean)stack.method_57824((class_9331)ModDataComponents.DISMOUNT.get());
        return dismount != null ? dismount : false;
    }

    public void setDismount(class_1799 stack, boolean dismount) {
        stack.method_57379((class_9331)ModDataComponents.DISMOUNT.get(), (Object)dismount);
    }

    public float getRideSpeed(class_1799 stack) {
        Float speed = (Float)stack.method_57824((class_9331)ModDataComponents.RIDE_SPEED.get());
        return speed != null ? speed.floatValue() : 0.0f;
    }

    public void setRideSpeed(class_1799 stack, float speed) {
        stack.method_57379((class_9331)ModDataComponents.RIDE_SPEED.get(), (Object)Float.valueOf(speed));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void registerModelProperty() {
        ItemPropertiesRegistry.register((class_1935)this, (class_2960)class_2960.method_60655((String)"magistuarmory", (String)"raised"), (stack, level, entity, i) -> this.isRaised(entity) ? 1.0f : 0.0f);
    }
}

