/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester.neoforge.events;

import com.natamus.collective_common_neoforge.functions.WorldFunctions;
import com.natamus.treeharvester_common_neoforge.events.TreeCutEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber
public class NeoForgeTreeCutEvents {
    @SubscribeEvent
    public static void onTreeHarvest(BlockEvent.BreakEvent e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        TreeCutEvents.onTreeHarvest(level, e.getPlayer(), e.getPos(), e.getState(), null);
    }

    @SubscribeEvent
    public static void onHarvestBreakSpeed(PlayerEvent.BreakSpeed e) {
        float newSpeed;
        Player player = e.getEntity();
        Level level = player.level();
        float originalSpeed = e.getOriginalSpeed();
        if (originalSpeed != (newSpeed = TreeCutEvents.onHarvestBreakSpeed(level, player, originalSpeed, e.getState()))) {
            e.setNewSpeed(newSpeed);
        }
    }
}

