/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients;

import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.input.ClickableIngredient;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.Translator;
import mezz.jei.core.util.WeakList;
import mezz.jei.library.ingredients.IngredientInfo;
import mezz.jei.library.ingredients.RegisteredIngredients;
import mezz.jei.library.ingredients.TypedIngredient;
import net.minecraft.class_2960;
import net.minecraft.class_768;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class IngredientManager
implements IIngredientManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final RegisteredIngredients registeredIngredients;
    private final WeakList<IIngredientManager.IIngredientListener> listeners = new WeakList();

    public IngredientManager(RegisteredIngredients registeredIngredients) {
        this.registeredIngredients = registeredIngredients;
    }

    @Override
    public <V> @Unmodifiable Collection<V> getAllIngredients(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        return this.registeredIngredients.getIngredientInfo(ingredientType).getAllIngredients();
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(V ingredient) {
        return this.getIngredientTypeChecked(ingredient).map(this::getIngredientHelper).orElseThrow(() -> new IllegalArgumentException("Unknown ingredient class: " + String.valueOf(ingredient.getClass())));
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        return this.registeredIngredients.getIngredientInfo(ingredientType).getIngredientHelper();
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(V ingredient) {
        return this.getIngredientTypeChecked(ingredient).map(this::getIngredientRenderer).orElseThrow(() -> new IllegalArgumentException("Unknown ingredient class: " + String.valueOf(ingredient.getClass())));
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        return this.registeredIngredients.getIngredientInfo(ingredientType).getIngredientRenderer();
    }

    @Override
    public Collection<IIngredientType<?>> getRegisteredIngredientTypes() {
        return this.registeredIngredients.getIngredientTypes();
    }

    @Override
    public Optional<IIngredientType<?>> getIngredientTypeForUid(String ingredientTypeUid) {
        ErrorUtil.checkNotNull(ingredientTypeUid, "ingredientTypeUid");
        return this.registeredIngredients.getIngredientTypes().stream().filter(t -> ingredientTypeUid.equals(t.getUid())).findFirst();
    }

    @Override
    public <V> void addIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        ErrorUtil.assertMainThread();
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        IngredientInfo<V> ingredientInfo = this.registeredIngredients.getIngredientInfo(ingredientType);
        IIngredientHelper ingredientHelper = ingredientInfo.getIngredientHelper();
        LOGGER.info("Ingredients are being added at runtime: {} {}", (Object)ingredients.size(), (Object)ingredientType.getIngredientClass().getName());
        if (LOGGER.isDebugEnabled()) {
            String ingredientStrings = ingredients.stream().map(ingredientHelper::getResourceLocation).map(class_2960::toString).collect(Collectors.joining("\n", "[", "]"));
            LOGGER.debug("Ingredients added at runtime: {}", (Object)ingredientStrings);
        }
        List<Object> validIngredients = ingredients.stream().filter(i -> {
            if (!ingredientHelper.isValidIngredient(i)) {
                String errorInfo = ingredientHelper.getErrorInfo(i);
                LOGGER.error("Attempted to add an invalid Ingredient: {}", (Object)errorInfo);
                return false;
            }
            if (!ingredientHelper.isIngredientOnServer(i)) {
                String errorInfo = ingredientHelper.getErrorInfo(i);
                LOGGER.error("Attempted to add an Ingredient that is not on the server: {}", (Object)errorInfo);
                return false;
            }
            return true;
        }).toList();
        ingredientInfo.addIngredients(validIngredients);
        if (!this.listeners.isEmpty()) {
            List<ITypedIngredient> typedIngredients = validIngredients.stream().map(i -> TypedIngredient.createUnvalidated(ingredientType, i)).toList();
            this.listeners.forEach(listener -> listener.onIngredientsAdded(ingredientHelper, typedIngredients));
        }
    }

    @Override
    @Nullable
    public <V> IIngredientType<V> getIngredientType(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        return this.registeredIngredients.getIngredientType(ingredient);
    }

    @Override
    public <V> Optional<IIngredientType<V>> getIngredientTypeChecked(V ingredient) {
        IIngredientType<V> ingredientType = this.getIngredientType(ingredient);
        return Optional.ofNullable(ingredientType);
    }

    @Override
    public <B, I> Optional<IIngredientTypeWithSubtypes<B, I>> getIngredientTypeWithSubtypesFromBase(B baseIngredient) {
        ErrorUtil.checkNotNull(baseIngredient, "baseIngredient");
        return this.registeredIngredients.getIngredientTypeWithSubtypesFromBase(baseIngredient);
    }

    @Override
    public <V> Optional<IIngredientType<V>> getIngredientTypeChecked(Class<? extends V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        IIngredientType<? extends V> ingredientType = this.registeredIngredients.getIngredientType(ingredientClass);
        return Optional.ofNullable(ingredientType);
    }

    @Override
    public <V> void removeIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        ErrorUtil.assertMainThread();
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        IngredientInfo<V> ingredientInfo = this.registeredIngredients.getIngredientInfo(ingredientType);
        IIngredientHelper ingredientHelper = ingredientInfo.getIngredientHelper();
        LOGGER.info("Ingredients are being removed at runtime: {} {}", (Object)ingredients.size(), (Object)ingredientType.getIngredientClass().getName());
        if (LOGGER.isDebugEnabled()) {
            String ingredientStrings = ingredients.stream().map(ingredientHelper::getResourceLocation).map(class_2960::toString).collect(Collectors.joining("\n", "[", "]"));
            LOGGER.debug("Ingredients removed at runtime: {}", (Object)ingredientStrings);
        }
        ingredientInfo.removeIngredients(ingredients);
        if (!this.listeners.isEmpty()) {
            List typedIngredients = TypedIngredient.createAndFilterInvalidNonnullList(this, ingredientType, ingredients, false);
            this.listeners.forEach(listener -> listener.onIngredientsRemoved(ingredientHelper, typedIngredients));
        }
    }

    @Override
    public void registerIngredientListener(IIngredientManager.IIngredientListener listener) {
        ErrorUtil.checkNotNull(listener, "listener");
        this.listeners.add(listener);
    }

    @Override
    public <V> Optional<ITypedIngredient<V>> createTypedIngredient(IIngredientType<V> ingredientType, V ingredient) {
        ITypedIngredient<V> result = TypedIngredient.createAndFilterInvalid(this, ingredientType, ingredient, false);
        return Optional.ofNullable(result);
    }

    @Override
    public <V> ITypedIngredient<V> normalizeTypedIngredient(ITypedIngredient<V> typedIngredient) {
        ErrorUtil.checkNotNull(typedIngredient, "typedIngredient");
        IIngredientType<V> type = typedIngredient.getType();
        IIngredientHelper<V> ingredientHelper = this.getIngredientHelper(type);
        return TypedIngredient.normalize(typedIngredient, ingredientHelper);
    }

    @Override
    public <V> Optional<IClickableIngredient<V>> createClickableIngredient(IIngredientType<V> ingredientType, V ingredient, class_768 area, boolean normalize) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        ErrorUtil.checkNotNull(area, "area");
        ITypedIngredient<V> typedIngredient = TypedIngredient.createAndFilterInvalid(this, ingredientType, ingredient, normalize);
        if (typedIngredient == null) {
            return Optional.empty();
        }
        ImmutableRect2i slotArea = new ImmutableRect2i(area);
        ClickableIngredient<V> clickableIngredient = new ClickableIngredient<V>(typedIngredient, slotArea);
        return Optional.of(clickableIngredient);
    }

    @Override
    @Deprecated
    public <V> Optional<V> getIngredientByUid(IIngredientType<V> ingredientType, String ingredientUuid) {
        return this.registeredIngredients.getIngredientInfo(ingredientType).getIngredientByLegacyUid(ingredientUuid);
    }

    @Override
    @Deprecated
    public <V> Optional<ITypedIngredient<V>> getTypedIngredientByUid(IIngredientType<V> ingredientType, String ingredientUuid) {
        return this.registeredIngredients.getIngredientInfo(ingredientType).getIngredientByLegacyUid(ingredientUuid).flatMap(i -> {
            ITypedIngredient<Object> typedIngredient = TypedIngredient.createAndFilterInvalid(this, ingredientType, i, true);
            return Optional.ofNullable(typedIngredient);
        });
    }

    @Override
    public <V> Codec<V> getIngredientCodec(IIngredientType<V> ingredientType) {
        return this.registeredIngredients.getIngredientInfo(ingredientType).getIngredientCodec();
    }

    @Override
    public Collection<String> getIngredientAliases(ITypedIngredient<?> ingredient) {
        return this.getIngredientAliasesInternal(ingredient);
    }

    private <T> Collection<String> getIngredientAliasesInternal(ITypedIngredient<T> typedIngredient) {
        return this.registeredIngredients.getIngredientInfo(typedIngredient.getType()).getIngredientAliases(typedIngredient).stream().map(Translator::translateToLocal).sorted(String::compareToIgnoreCase).toList();
    }
}

