/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.render.batch;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.rendering.BatchRenderElement;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.library.render.ItemStackRenderer;
import mezz.jei.library.render.batch.ElementWithModel;
import mezz.jei.library.render.batch.LimitedQuadItemModel;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_811;
import net.minecraft.class_918;

public final class ItemStackBatchRenderer {
    private final List<ElementWithModel> useBlockLight = new ArrayList<ElementWithModel>();
    private final List<ElementWithModel> noBlockLight = new ArrayList<ElementWithModel>();
    private final List<BatchRenderElement<class_1799>> customRender = new ArrayList<BatchRenderElement<class_1799>>();

    public ItemStackBatchRenderer(class_310 minecraft, List<BatchRenderElement<class_1799>> elements) {
        class_638 level = minecraft.field_1687;
        class_918 itemRenderer = minecraft.method_1480();
        for (BatchRenderElement<class_1799> element : elements) {
            ElementWithModel elementWithModel;
            class_1799 itemStack = element.ingredient();
            if (itemStack.method_7960()) continue;
            class_1087 bakedmodel = itemRenderer.method_4019(itemStack, (class_1937)level, null, 0);
            if (bakedmodel.method_4713()) {
                this.customRender.add(element);
                continue;
            }
            if (bakedmodel.method_24304()) {
                elementWithModel = new ElementWithModel(bakedmodel, itemStack, element.x(), element.y());
                this.useBlockLight.add(elementWithModel);
                continue;
            }
            if (!bakedmodel.method_4712()) {
                bakedmodel = new LimitedQuadItemModel(bakedmodel);
            }
            elementWithModel = new ElementWithModel(bakedmodel, itemStack, element.x(), element.y());
            this.noBlockLight.add(elementWithModel);
        }
    }

    public void render(class_332 guiGraphics, class_310 minecraft, class_918 itemRenderer, ItemStackRenderer itemStackRenderer) {
        class_327 font;
        class_1799 ingredient;
        if (!this.noBlockLight.isEmpty()) {
            class_308.method_24210();
            for (ElementWithModel element : this.noBlockLight) {
                this.renderItem(guiGraphics, itemRenderer, element.model(), element.stack(), element.x(), element.y());
            }
            guiGraphics.method_51452();
            class_308.method_24211();
        }
        if (!this.useBlockLight.isEmpty()) {
            class_308.method_24211();
            for (ElementWithModel element : this.useBlockLight) {
                this.renderItem(guiGraphics, itemRenderer, element.model(), element.stack(), element.x(), element.y());
            }
            guiGraphics.method_51452();
        }
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        for (ElementWithModel elementWithModel : this.useBlockLight) {
            ingredient = elementWithModel.stack();
            font = renderHelper.getFontRenderer(minecraft, ingredient);
            guiGraphics.method_51431(font, ingredient, elementWithModel.x(), elementWithModel.y());
        }
        for (ElementWithModel elementWithModel : this.noBlockLight) {
            ingredient = elementWithModel.stack();
            font = renderHelper.getFontRenderer(minecraft, ingredient);
            guiGraphics.method_51431(font, ingredient, elementWithModel.x(), elementWithModel.y());
        }
        RenderSystem.disableBlend();
        for (BatchRenderElement batchRenderElement : this.customRender) {
            ingredient = (class_1799)batchRenderElement.ingredient();
            itemStackRenderer.render(guiGraphics, ingredient, batchRenderElement.x(), batchRenderElement.y());
            RenderSystem.disableBlend();
        }
        RenderSystem.disableBlend();
    }

    private void renderItem(class_332 guiGraphics, class_918 itemRenderer, class_1087 bakedmodel, class_1799 itemStack, int x, int y) {
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)(x + 8), (float)(y + 8), 150.0f);
        poseStack.method_22905(16.0f, -16.0f, 16.0f);
        try {
            itemRenderer.method_23179(itemStack, class_811.field_4317, false, poseStack, (class_4597)guiGraphics.method_51450(), 0xF000F0, class_4608.field_21444, bakedmodel);
        }
        catch (Throwable throwable) {
            class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Rendering item");
            class_129 crashreportcategory = crashreport.method_562("Item being rendered");
            crashreportcategory.method_577("Item Type", () -> String.valueOf(itemStack.method_7909()));
            crashreportcategory.method_577("Item Components", () -> String.valueOf(itemStack.method_57353()));
            crashreportcategory.method_577("Item Foil", () -> String.valueOf(itemStack.method_7958()));
            throw new class_148(crashreport);
        }
        poseStack.method_22909();
    }
}

