/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import journeymap.api.v2.client.display.ImageOverlay;
import journeymap.api.v2.client.model.MapImage;
import journeymap.api.v2.client.model.TextProperties;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.BaseOverlayDrawStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.Renderer;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.common.CommonConstants;
import journeymap.common.Journeymap;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class DrawImageStep
extends BaseOverlayDrawStep<ImageOverlay> {
    private Point2D.Double northWestPosition;
    private Point2D.Double southEastPosition;
    private class_1043 iconTexture;
    private boolean hasError;

    public DrawImageStep(ImageOverlay marker) {
        super(marker);
    }

    @Override
    public void draw(class_332 graphics, class_4597 buffers, DrawStep.Pass pass, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
        if (!this.isOnScreen(xOffset, yOffset, renderer, rotation)) {
            return;
        }
        if (pass == DrawStep.Pass.Object) {
            this.ensureTexture();
            if (!this.hasError && this.iconTexture != null) {
                MapImage icon = ((ImageOverlay)this.overlay).getImage();
                double width = this.screenBounds.width;
                double height = this.screenBounds.height;
                class_1921 renderType = ((ImageOverlay)this.getOverlay()).getImage().isBlur() ? JMRenderTypes.getIconNoBlur((class_1044)this.iconTexture) : JMRenderTypes.getIcon((class_1044)this.iconTexture);
                class_4588 vertexBuilder = buffers.getBuffer(renderType);
                DrawUtil.drawQuad(graphics.method_51448(), vertexBuilder, icon.getColor(), icon.getOpacity(), this.northWestPosition.x + xOffset, this.northWestPosition.y + yOffset, width, height, 0.0, 0.0, icon.getDisplayWidth() / (double)((TextureAccess)this.iconTexture).journeymap$getWidth(), icon.getDisplayHeight() / (double)((TextureAccess)this.iconTexture).journeymap$getHeight(), icon.getRotation(), false);
            }
        } else if (pass == DrawStep.Pass.Text) {
            super.drawText(graphics, pass, xOffset, yOffset, renderer, fontScale, rotation);
        }
    }

    protected void ensureTexture() {
        if (this.iconTexture != null) {
            return;
        }
        try {
            MapImage image = ((ImageOverlay)this.overlay).getImage();
            class_2960 resourceLocation = image.getImageLocation();
            class_2960 fake = class_2960.method_60655((String)"fake", (String)CommonConstants.getSafeString(((ImageOverlay)this.overlay).getGuid(), "-").toLowerCase(Locale.ROOT));
            if (resourceLocation == null) {
                class_1043 texture = new class_1043(image.getImage());
                class_310.method_1551().method_1531().method_4616(fake, (class_1044)texture);
                this.iconTexture = TextureCache.getTexture(fake);
            } else {
                this.iconTexture = TextureCache.getTexture(resourceLocation);
            }
            this.iconTexture.method_23207();
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error getting ImageOverlay marimage upperTexture: " + String.valueOf(e), (Throwable)e);
            this.hasError = true;
        }
    }

    @Override
    protected void updatePositions(Renderer renderer, double rotation) {
        this.northWestPosition = renderer.getBlockPixelInGrid(((ImageOverlay)this.overlay).getNorthWestPoint());
        this.southEastPosition = renderer.getBlockPixelInGrid(((ImageOverlay)this.overlay).getSouthEastPoint());
        this.screenBounds = new Rectangle2D.Double(this.northWestPosition.x, this.northWestPosition.y, 0.0, 0.0);
        this.screenBounds.add(this.southEastPosition);
        TextProperties textProperties = ((ImageOverlay)this.overlay).getTextProperties();
        this.labelPosition.setLocation(this.screenBounds.getCenterX() + (double)textProperties.getOffsetX(), this.screenBounds.getCenterY() + (double)textProperties.getOffsetY());
    }

    public static class SimpleCacheLoader
    extends CacheLoader<ImageOverlay, DrawImageStep> {
        public DrawImageStep load(ImageOverlay overlay) throws Exception {
            return new DrawImageStep(overlay);
        }
    }
}

