/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.colorpalette;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.IntStream;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.cartography.color.ColorPalette;
import journeymap.client.data.DataCache;
import journeymap.client.model.BiomeMD;
import journeymap.client.model.BlockMD;
import journeymap.client.properties.CoreProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.colorpalette.ColorPaletteItem;
import journeymap.client.ui.colorpalette.ColorPaletteScrollList;
import journeymap.client.ui.colorpalette.DomainDropDownButton;
import journeymap.client.ui.colorpalette.ModeDropDownButton;
import journeymap.client.ui.colorpalette.PaletteDropDownButton;
import journeymap.client.ui.component.SearchTextBox;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.SortButton;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.common.helper.BiomeHelper;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7842;
import net.minecraft.class_7847;
import net.minecraft.class_7852;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8016;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public class ColorPaletteScreen
extends JmUI {
    private final class_2561 labelClose = class_2561.method_43471((String)"jm.common.close");
    private final class_2561 labelManagePalettes = class_2561.method_43471((String)"jm.colorpalette.manage_palettes");
    private final class_2561 labelModsAndPlayers = class_2561.method_43471((String)"jm.colorpalette.mobs_and_players");
    private final class_2561 labelRetrievingColors = class_2561.method_43471((String)"jm.colorpalette.retrieving_colors");
    private static ColorPaletteItem.Sort currentSort;
    private static String searchString;
    class_8667 firstHeaderLayout;
    class_8667 secondHeaderLayout;
    protected ColorPaletteScrollList itemScrollPane;
    protected int rowHeight = 36;
    private SortButton buttonSortName;
    private SortButton buttonSortId;
    private ModeDropDownButton buttonMode;
    private PaletteDropDownButton buttonPalettes;
    private DomainDropDownButton buttonDomains;
    private SearchTextBox searchText;
    private ArrayList<? extends ColorPaletteItem> items = new ArrayList();
    private final ArrayList<ColorPaletteItem.Block> blockItems = new ArrayList();
    private final ArrayList<ColorPaletteItem.Biome> biomeItems = new ArrayList();
    private boolean remapNeeded = false;
    int firstHeaderHeight = 20;
    int secondHeaderHeight = 15;
    private Status status = Status.Uninitialized;
    private Iterator<class_2680> blockStatesToInitialize;
    private Iterator<class_6880.class_6883<class_1959>> biomesToInitialize;
    private class_7842 initializingColorCountString;
    private int initializingColorCount = 0;

    public ColorPaletteScreen(class_437 returnDisplay) {
        super(Constants.getString("jm.colorpalette.manage_colors_title"), true, returnDisplay);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        if (this.status != Status.Initialized) {
            class_8667 content = class_8667.method_52742();
            this.contentLayout.method_46441((class_8021)content);
            content.method_52736((class_8021)new class_7842(this.labelRetrievingColors, this.field_22793));
            content.method_52736((class_8021)class_7852.method_46512((int)6));
            this.initializingColorCountString = (class_7842)content.method_52736((class_8021)new class_7842((class_2561)class_2561.method_43470((String)"0"), this.field_22793));
            this.initializingColorCountString.method_25358(this.field_22793.method_1727("0000000"));
            this.footerLayout.method_52736((class_8021)Button.method_46430((class_2561)this.labelClose, b -> this.refreshAndClose()).method_46432(this.field_22793.method_27525((class_5348)this.labelClose) + 10).method_46431());
            this.method_48640();
            return;
        }
        class_8667 content = class_8667.method_52741();
        this.contentLayout.method_46441((class_8021)content);
        this.firstHeaderLayout = class_8667.method_52742();
        this.firstHeaderLayout.method_52735(2);
        content.method_52738((class_8021)this.firstHeaderLayout, class_7847::method_46467);
        this.firstHeaderLayout.method_52736((class_8021)class_7852.method_46513((int)this.firstHeaderHeight));
        this.buttonMode = (ModeDropDownButton)this.firstHeaderLayout.method_52738((class_8021)new ModeDropDownButton(b -> this.updateItems()), class_7847::method_46474);
        this.buttonMode.setDefaultStyle(false);
        this.buttonMode.setDrawBackground(false);
        this.buttonMode.method_53533(15);
        boolean hasGlobal = ColorManager.INSTANCE.getGlobalPalette().hasBlockStateColors();
        boolean hasWorld = ColorManager.INSTANCE.getWorldPalette().hasBlockStateColors();
        this.buttonPalettes = (PaletteDropDownButton)this.firstHeaderLayout.method_52738((class_8021)new PaletteDropDownButton(hasGlobal, hasWorld, b -> this.updateItems()), class_7847::method_46474);
        this.buttonPalettes.setVisible(hasGlobal || hasWorld);
        this.buttonPalettes.setDefaultStyle(false);
        this.buttonPalettes.setDrawBackground(false);
        this.buttonPalettes.method_53533(15);
        if (ColorManager.INSTANCE.getDefaultPalette().hasModdedBlockOrBiome()) {
            this.buttonDomains = (DomainDropDownButton)this.firstHeaderLayout.method_52738((class_8021)new DomainDropDownButton(ColorManager.INSTANCE.getDefaultPalette(), b -> this.updateItems()), class_7847::method_46474);
            this.buttonDomains.setDefaultStyle(false);
            this.buttonDomains.setDrawBackground(false);
            this.buttonDomains.method_53533(15);
        }
        this.secondHeaderLayout = class_8667.method_52742();
        this.secondHeaderLayout.method_52735(2);
        content.method_52738((class_8021)this.secondHeaderLayout, class_7847::method_46467);
        this.secondHeaderLayout.method_52736((class_8021)class_7852.method_46513((int)this.secondHeaderHeight));
        this.buttonSortName = (SortButton)this.secondHeaderLayout.method_52738((class_8021)new SortButton(Constants.getString("jm.colorpalette.name"), "name", false, this::sortButtonPressed), class_7847::method_46474);
        this.buttonSortId = (SortButton)this.secondHeaderLayout.method_52738((class_8021)new SortButton(Constants.getString("jm.colorpalette.id"), "id", false, this::sortButtonPressed), class_7847::method_46474);
        this.searchText = (SearchTextBox)this.secondHeaderLayout.method_52738((class_8021)new SearchTextBox(searchString, this.field_22793, 70, 14), class_7847::method_46474);
        this.searchText.method_1858(false);
        this.searchText.setFillColor(0, 0.4f);
        this.searchText.method_1863(t -> this.updateItems());
        this.footerLayout.method_52736((class_8021)Button.method_46430((class_2561)this.labelModsAndPlayers, b -> UIManager.INSTANCE.openMobsAndPlayersColorEditor(this)).method_46432(this.field_22793.method_27525((class_5348)this.labelModsAndPlayers) + 10).method_46431());
        this.footerLayout.method_52736((class_8021)Button.method_46430((class_2561)this.labelManagePalettes, b -> UIManager.INSTANCE.openColorPaletteManager(this)).method_46432(this.field_22793.method_27525((class_5348)this.labelManagePalettes) + 10).method_46431());
        this.footerLayout.method_52736((class_8021)Button.method_46430((class_2561)this.labelClose, b -> this.refreshAndClose()).method_46432(this.field_22793.method_27525((class_5348)this.labelClose) + 10).method_46431());
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.itemScrollPane = (ColorPaletteScrollList)content.method_52736(new ColorPaletteScrollList(this.field_22787, 0, 36 + this.firstHeaderHeight + this.secondHeaderHeight, this.field_22789, this.field_22790 - 36 - 30 - this.firstHeaderHeight - this.secondHeaderHeight, this.rowHeight));
        SortButton sortButton = this.getInitialSort();
        currentSort = this.getSortFromButton(sortButton);
        this.method_48640();
    }

    @Override
    protected void method_48640() {
        if (this.status == Status.Initialized) {
            this.updateItems();
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            this.itemScrollPane.updateSize(this.field_22789, this.field_22790 - 36 - 30 - this.firstHeaderHeight - this.secondHeaderHeight, 0, 36 + this.firstHeaderHeight + this.secondHeaderHeight);
            this.itemScrollPane.setListWidth(this.panelWidth());
            this.itemScrollPane.method_25307(this.itemScrollPane.method_25341());
        }
        super.method_48640();
    }

    @Override
    public void method_25394(class_332 graphics, int x, int y, float partialTicks) {
        class_638 level;
        if (this.status == Status.Uninitialized && (level = this.field_22787.field_1687) != null) {
            this.blockStatesToInitialize = class_2248.field_10651.iterator();
            this.biomesToInitialize = level.method_30349().method_30530(class_7924.field_41236).method_40270().iterator();
            this.status = Status.Initializing;
        }
        if (this.status == Status.Initializing) {
            long start = System.currentTimeMillis();
            boolean finished = false;
            while (!finished && System.currentTimeMillis() - start < 30L) {
                if (this.blockStatesToInitialize.hasNext()) {
                    BlockMD.get(this.blockStatesToInitialize.next());
                    ++this.initializingColorCount;
                }
                if (this.biomesToInitialize.hasNext()) {
                    BiomeMD.get((class_6880<class_1959>)((class_6880)this.biomesToInitialize.next()));
                    ++this.initializingColorCount;
                }
                String count = Integer.toString(this.initializingColorCount);
                this.initializingColorCountString.method_25355((class_2561)class_2561.method_43470((String)count));
                if (this.blockStatesToInitialize.hasNext() || this.biomesToInitialize.hasNext()) continue;
                finished = true;
                this.status = Status.Initialized;
                super.method_41843();
            }
        }
        if (this.status == Status.Initialized) {
            this.buttonSortName.setEnabled(!this.items.isEmpty());
            this.buttonSortId.setEnabled(!this.items.isEmpty());
        }
        super.method_25394(graphics, x, y, partialTicks);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.outline(graphics, 0, 36, this.field_22789 - 1, this.field_22790 - 66);
        DrawUtil.drawRectangle(graphics, 0.0, 36 + this.firstHeaderHeight, this.field_22789 - 1, 1.0, 0xC0C0C0, 0.8f);
        DrawUtil.drawRectangle(graphics, 0.0, 36 + this.firstHeaderHeight + this.secondHeaderHeight, this.field_22789 - 1, 1.0, 0xC0C0C0, 0.8f);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (this.searchText != null && this.searchText.method_25405(mouseX, mouseY)) {
            this.searchText.method_25402(mouseX, mouseY, mouseButton);
            super.method_25395((class_364)this.searchText);
            return true;
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25400(char typedChar, int keyCode) {
        if (this.searchText != null && this.searchText.method_25367()) {
            return this.searchText.method_25400(typedChar, keyCode);
        }
        return super.method_25400(typedChar, keyCode);
    }

    public void method_48263(class_8016 path) {
        super.method_48263(path);
    }

    public void copyBlock(String blockId, boolean globalToWorld) {
        ColorPalette worldPalette = ColorManager.INSTANCE.getWorldPalette();
        ColorPalette globalPalette = ColorManager.INSTANCE.getGlobalPalette();
        if (globalToWorld) {
            worldPalette.copyBlockFromPalette(globalPalette, blockId);
        } else {
            globalPalette.copyBlockFromPalette(worldPalette, blockId);
        }
        ColorPaletteItem selected = (ColorPaletteItem)this.itemScrollPane.method_25334();
        this.updateItems();
        if (selected != null) {
            this.selectItem(selected.id, selected.palette);
        }
        this.setRemapNeeded();
    }

    public void copyBiome(String biomeId, boolean globalToWorld) {
        ColorPalette worldPalette = ColorManager.INSTANCE.getWorldPalette();
        ColorPalette globalPalette = ColorManager.INSTANCE.getGlobalPalette();
        if (globalToWorld) {
            worldPalette.copyBiomeFromPalette(globalPalette, biomeId);
        } else {
            globalPalette.copyBiomeFromPalette(worldPalette, biomeId);
        }
        ColorPaletteItem selected = (ColorPaletteItem)this.itemScrollPane.method_25334();
        this.updateItems();
        if (selected != null) {
            this.selectItem(selected.id, selected.palette);
        }
        this.setRemapNeeded();
    }

    public void removeBlockFromPalette(String blockId, ColorPalette.Type type) {
        ColorPalette palette = type == ColorPalette.Type.Global ? ColorManager.INSTANCE.getGlobalPalette() : ColorManager.INSTANCE.getWorldPalette();
        palette.removeBlock(blockId);
        this.updateItems();
        this.selectItem(blockId, ColorManager.INSTANCE.getDefaultPalette());
        this.setRemapNeeded();
    }

    public void removeBiomeFromPalette(String biomeId, ColorPalette.Type type) {
        ColorPalette palette = type == ColorPalette.Type.Global ? ColorManager.INSTANCE.getGlobalPalette() : ColorManager.INSTANCE.getWorldPalette();
        palette.removeBiome(biomeId);
        this.updateItems();
        this.selectItem(biomeId, ColorManager.INSTANCE.getDefaultPalette());
        this.setRemapNeeded();
    }

    public void setRemapNeeded() {
        this.remapNeeded = true;
    }

    protected void selectItem(String id, ColorPalette palette) {
        if (this.items.isEmpty()) {
            return;
        }
        int index = IntStream.range(0, this.items.size()).filter(i -> id.equals(this.items.get((int)i).id) && palette == this.items.get((int)i).palette).findFirst().orElse(0);
        ColorPaletteItem toSelect = (ColorPaletteItem)this.itemScrollPane.getSlot(index);
        this.itemScrollPane.method_25395((class_364)toSelect);
        toSelect.focusEditButton();
    }

    protected void updateItems() {
        if (this.searchText == null) {
            return;
        }
        if (this.buttonMode.getSelected().getId().equals("blocks")) {
            this.updateBlockItems();
            this.items = this.blockItems;
        } else {
            this.updateBiomeItems();
            this.items = this.biomeItems;
        }
        this.items.sort(currentSort);
        this.itemScrollPane.setSlots(this.items);
        this.itemScrollPane.method_25307(this.itemScrollPane.method_25341());
    }

    protected void updateBlockItems() {
        ColorPaletteItem.Block item;
        boolean hasGlobal = ColorManager.INSTANCE.getGlobalPalette().hasBlockStateColors();
        boolean hasWorld = ColorManager.INSTANCE.getWorldPalette().hasBlockStateColors();
        this.buttonPalettes.setValidPalettes(hasGlobal, hasWorld);
        this.buttonPalettes.setVisible(hasGlobal || hasWorld);
        this.blockItems.clear();
        String domain = DomainDropDownButton.currentDomain;
        searchString = this.searchText.method_1882();
        boolean all = PaletteDropDownButton.currentPalette.equals("all");
        ColorPalette defaultPalette = ColorManager.INSTANCE.getDefaultPalette();
        if (all) {
            for (String blockId : defaultPalette.getAllBlocks()) {
                if (!this.filterDomain(domain, blockId) || !this.filterBlockSearch(searchString, blockId)) continue;
                ColorPaletteItem.Block item2 = new ColorPaletteItem.Block(defaultPalette, blockId, false, this.getFontRenderer(), this);
                this.blockItems.add(item2);
            }
        }
        boolean global = PaletteDropDownButton.currentPalette.equals("global");
        boolean world = PaletteDropDownButton.currentPalette.equals("world");
        if (all || global) {
            ColorPalette globalPalette = ColorManager.INSTANCE.getGlobalPalette();
            for (String blockId : globalPalette.getAllBlocks()) {
                if (!this.filterDomain(domain, blockId) || !this.filterBlockSearch(searchString, blockId) || !defaultPalette.hasBlockId(blockId)) continue;
                item = new ColorPaletteItem.Block(globalPalette, blockId, all, this.getFontRenderer(), this);
                this.blockItems.add(item);
            }
        }
        if (all || world) {
            ColorPalette worldPalette = ColorManager.INSTANCE.getWorldPalette();
            for (String blockId : worldPalette.getAllBlocks()) {
                if (!this.filterDomain(domain, blockId) || !this.filterBlockSearch(searchString, blockId) || !defaultPalette.hasBlockId(blockId)) continue;
                item = new ColorPaletteItem.Block(worldPalette, blockId, all, this.getFontRenderer(), this);
                this.blockItems.add(item);
            }
        }
    }

    protected void updateBiomeItems() {
        ColorPaletteItem.Biome item;
        boolean hasGlobal = ColorManager.INSTANCE.getGlobalPalette().hasBiomeColors();
        boolean hasWorld = ColorManager.INSTANCE.getWorldPalette().hasBiomeColors();
        this.buttonPalettes.setValidPalettes(hasGlobal, hasWorld);
        this.buttonPalettes.setVisible(hasGlobal || hasWorld);
        this.biomeItems.clear();
        String domain = DomainDropDownButton.currentDomain;
        searchString = this.searchText.method_1882();
        boolean all = PaletteDropDownButton.currentPalette.equals("all");
        ColorPalette defaultPalette = ColorManager.INSTANCE.getDefaultPalette();
        if (all) {
            for (String biomeId : defaultPalette.getAllBiomes()) {
                if (!this.filterDomain(domain, biomeId) || !this.filterBiomeSearch(searchString, biomeId)) continue;
                ColorPaletteItem.Biome item2 = new ColorPaletteItem.Biome(defaultPalette, biomeId, false, this.getFontRenderer(), this);
                this.biomeItems.add(item2);
            }
        }
        boolean global = PaletteDropDownButton.currentPalette.equals("global");
        boolean world = PaletteDropDownButton.currentPalette.equals("world");
        if (all || global) {
            ColorPalette globalPalette = ColorManager.INSTANCE.getGlobalPalette();
            for (String biomeId : globalPalette.getAllBiomes()) {
                if (!this.filterDomain(domain, biomeId) || !this.filterBiomeSearch(searchString, biomeId) || !defaultPalette.hasBiomeId(biomeId)) continue;
                item = new ColorPaletteItem.Biome(globalPalette, biomeId, all, this.getFontRenderer(), this);
                this.biomeItems.add(item);
            }
        }
        if (all || world) {
            ColorPalette worldPalette = ColorManager.INSTANCE.getWorldPalette();
            for (String biomeId : worldPalette.getAllBiomes()) {
                if (!this.filterDomain(domain, biomeId) || !this.filterBiomeSearch(searchString, biomeId) || !defaultPalette.hasBiomeId(biomeId)) continue;
                item = new ColorPaletteItem.Biome(worldPalette, biomeId, all, this.getFontRenderer(), this);
                this.biomeItems.add(item);
            }
        }
    }

    private int panelWidth() {
        return Math.min(this.field_22789, 480);
    }

    private boolean filterDomain(String domain, String id) {
        return domain == null || domain.isEmpty() || class_2960.method_60654((String)id).method_12836().equals(domain);
    }

    private boolean filterBlockSearch(String search, String blockId) {
        String blockName = BlockMD.getBlockName((class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)blockId))).toLowerCase(Locale.ROOT);
        return this.filterSearch(search, blockId, blockName);
    }

    private boolean filterBiomeSearch(String search, String biomeId) {
        String biomeName = BiomeHelper.getTranslatedBiomeName(class_2960.method_60654((String)biomeId)).toLowerCase(Locale.ROOT);
        return this.filterSearch(search, biomeId, biomeName);
    }

    private boolean filterSearch(String search, String id, String name) {
        if (search == null || search.isEmpty()) {
            return true;
        }
        search = search.toLowerCase(Locale.ROOT);
        return id.toLowerCase(Locale.ROOT).contains(search) || name.contains(search);
    }

    private void sortButtonPressed(class_4185 button) {
        SortButton sortButton = (SortButton)button;
        sortButton.toggle();
        currentSort = this.getSortFromButton(sortButton);
        this.updateSortProperty(sortButton);
        this.items.sort(currentSort);
        this.itemScrollPane.setSlots(this.items);
    }

    private ColorPaletteItem.Sort getSortFromButton(SortButton sortButton) {
        if (sortButton.getKey().equals("name")) {
            return new ColorPaletteItem.NameComparator(sortButton.getToggled());
        }
        return new ColorPaletteItem.IdComparator(sortButton.getToggled());
    }

    protected void refreshAndClose() {
        this.closeAndReturn();
    }

    @Override
    protected void closeAndReturn() {
        if (this.remapNeeded) {
            DataCache.INSTANCE.resetBlockMetadata();
            DataCache.INSTANCE.resetBiomeMetadata();
            ColorManager.INSTANCE.savePalettes();
            MapPlayerTask.forceNearbyRemap();
        }
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open((class_437)returnDisplayStack.pop());
        }
    }

    private SortButton getInitialSort() {
        CoreProperties prop = JourneymapClient.getInstance().getCoreProperties();
        boolean descending = prop.sortDescending.get();
        SortButton button = switch ((ColorPaletteItem.SortType)((Object)prop.initialSortOrder.get())) {
            default -> throw new MatchException(null, null);
            case ColorPaletteItem.SortType.Id -> this.buttonSortId;
            case ColorPaletteItem.SortType.Name -> this.buttonSortName;
        };
        button.setToggled(descending);
        return button;
    }

    private void updateSortProperty(SortButton sortButton) {
        CoreProperties prop = JourneymapClient.getInstance().getCoreProperties();
        if (sortButton == this.buttonSortName) {
            prop.initialSortOrder.set(ColorPaletteItem.SortType.Name);
        } else {
            prop.initialSortOrder.set(ColorPaletteItem.SortType.Id);
        }
        prop.sortDescending.set(sortButton.getToggled());
        prop.save();
    }

    static {
        searchString = "";
    }

    private static enum Status {
        Uninitialized,
        Initializing,
        Initialized;

    }
}

