/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import journeymap.api.client.impl.ClientAPI;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.Displayable;
import journeymap.api.v2.client.display.Overlay;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.fullscreen.IFullscreen;
import journeymap.api.v2.client.model.MapPolygon;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.api.v2.client.util.UIState;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.data.WaypointsData;
import journeymap.client.event.dispatchers.CustomEventDispatcher;
import journeymap.client.event.dispatchers.FullscreenEventDispatcher;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.io.MapSaver;
import journeymap.client.io.ThemeLoader;
import journeymap.client.log.ChatLog;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BlockMD;
import journeymap.client.model.EntityDTO;
import journeymap.client.model.MapState;
import journeymap.client.model.MapType;
import journeymap.client.properties.CoreProperties;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.draw.RadarDrawStepFactory;
import journeymap.client.render.draw.WaypointDrawStepFactory;
import journeymap.client.render.map.MapRenderer;
import journeymap.client.render.map.RegionRenderer;
import journeymap.client.task.multi.MapRegionTask;
import journeymap.client.task.multi.SaveMapTask;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.IntSliderButton;
import journeymap.client.ui.component.screens.JmUILegacy;
import journeymap.client.ui.dialog.AutoMapConfirmation;
import journeymap.client.ui.dialog.DeleteMapConfirmation;
import journeymap.client.ui.dialog.FullscreenActions;
import journeymap.client.ui.fullscreen.FullscreenTextBoxButton;
import journeymap.client.ui.fullscreen.FullscreenThemeDropdownButton;
import journeymap.client.ui.fullscreen.MapChat;
import journeymap.client.ui.fullscreen.layer.LayerDelegate;
import journeymap.client.ui.fullscreen.menu.FullScreenPopupMenu;
import journeymap.client.ui.minimap.Shape;
import journeymap.client.ui.option.LocationFormat;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeButton;
import journeymap.client.ui.theme.ThemeToggle;
import journeymap.client.ui.theme.ThemeToolbar;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.StringField;
import journeymap.common.version.VersionCheck;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_746;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class Fullscreen
extends JmUILegacy
implements IFullscreen {
    private long lastGridUpdate = 0L;
    private static final MapState state = new MapState();
    private static final MapRenderer mapRenderer = new MapRenderer(Context.UI.Fullscreen);
    private final WaypointDrawStepFactory waypointRenderer = new WaypointDrawStepFactory();
    private final RadarDrawStepFactory radarRenderer = new RadarDrawStepFactory();
    private final LayerDelegate layerDelegate;
    private FullMapProperties fullMapProperties = JourneymapClient.getInstance().getFullMapProperties();
    private CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
    private boolean firstLayoutPass = true;
    private static boolean buttonsVisible = true;
    private Boolean isDragging = false;
    private int mouseDragX;
    private int mouseDragY;
    private int mx;
    private int my;
    private Logger logger = Journeymap.getLogger();
    private MapChat chat;
    private ThemeButton buttonFollow;
    private ThemeButton buttonZoomIn;
    private ThemeButton buttonZoomOut;
    private ThemeButton buttonSearch;
    private FullscreenTextBoxButton searchTextX;
    private FullscreenTextBoxButton searchTextZ;
    private ThemeButton buttonExecuteSearch;
    private ThemeToolbar searchToolBar;
    private ThemeButton buttonDay;
    private ThemeButton buttonNight;
    private ThemeButton buttonTopo;
    private ThemeButton buttonBiome;
    private ThemeButton buttonLayers;
    private ThemeButton buttonCaves;
    private ThemeButton buttonAlert;
    private ThemeButton buttonOptions;
    private ThemeButton buttonClose;
    private FullscreenThemeDropdownButton buttonTheme;
    private boolean buttonThemeNeedReopen = false;
    private ThemeButton buttonWaypointManager;
    private ThemeButton buttonMobs;
    private ThemeButton buttonAnimals;
    private ThemeButton buttonPets;
    private ThemeButton buttonVillagers;
    private ThemeButton buttonPlayers;
    private ThemeButton buttonGrid;
    private ThemeButton buttonKeys;
    private ThemeButton buttonAutomap;
    private ThemeButton buttonSavemap;
    private ThemeButton buttonDeletemap;
    private ThemeButton buttonDisable;
    private ThemeButton buttonColorPalette;
    private ThemeButton buttonBrowser;
    private ThemeButton buttonAbout;
    ThemeButton overlayRenderButton;
    private ThemeToolbar mapTypeToolbar;
    private ThemeToolbar optionsToolbar;
    private ThemeToolbar menuToolbar;
    private ThemeToolbar zoomToolbar;
    private ThemeToolbar addonToolbar;
    private List<ThemeToolbar> customToolbars;
    private class_2338 zoomBlock;
    private int bgColor = 0x222222;
    private Theme.LabelSpec statusLabelSpec;
    private final StatTimer renderTimer = StatTimer.get("Fullscreen.render");
    private final StatTimer drawMapTimer = StatTimer.get("Fullscreen.render.drawMap", 50);
    private final StatTimer drawMapTimerWithRefresh = StatTimer.get("Fullscreen.drawMap+refreshState", 5);
    private final LocationFormat locationFormat = new LocationFormat();
    private final List<Overlay> tempOverlays = new ArrayList<Overlay>();
    private IntSliderButton sliderCaveLayer;
    private List<class_5481> autoMapOnTooltip;
    private List<class_5481> autoMapOffTooltip;
    private Rectangle2D.Double mapTypeToolbarBounds;
    private Rectangle2D.Double optionsToolbarBounds;
    private Rectangle2D.Double menuToolbarBounds;
    private final class_310 minecraft;
    public boolean chatOpenedFromEvent = false;
    public final FullScreenPopupMenu popupMenu = new FullScreenPopupMenu(this);
    private List<class_5481> entityTooltip;
    int zoom = 512;

    public Fullscreen() {
        super("Fullscreen Map");
        this.minecraft = class_310.method_1551();
        mapRenderer.clear();
        mapRenderer.setZoom(JourneymapClient.getInstance().getFullMapProperties().zoomLevel.get().intValue());
        this.layerDelegate = new LayerDelegate(this);
        if (JourneymapClient.getInstance().getFullMapProperties().showCaves.get().booleanValue() && DataCache.getPlayer().underground.booleanValue() && Fullscreen.state.follow.get() && FeatureManager.getInstance().isAllowed(Feature.MapCaves)) {
            state.setMapType(MapType.underground(DataCache.getPlayer()));
        }
    }

    public static synchronized MapState state() {
        return state;
    }

    public static synchronized UIState uiState() {
        return mapRenderer.getUIState();
    }

    public UIState getUiState() {
        return mapRenderer.getUIState();
    }

    public class_437 getScreen() {
        return this;
    }

    public void reset() {
        this.isDragging = false;
        state.requireRefresh();
        mapRenderer.clear();
        this.method_37067();
    }

    @Override
    public void method_25426() {
        this.fullMapProperties = JourneymapClient.getInstance().getFullMapProperties();
        state.requireRefresh();
        state.refresh(this.minecraft, (class_1657)class_310.method_1551().field_1724, this.fullMapProperties);
        MapType mapType = state.getMapType();
        if (!mapType.dimension.equals((Object)this.minecraft.field_1724.method_5770().method_27983())) {
            mapRenderer.clear();
        }
        this.initButtons();
        String thisVersion = Journeymap.JM_VERSION.toString();
        String splashViewed = JourneymapClient.getInstance().getCoreProperties().splashViewed.get();
        if (splashViewed == null || !thisVersion.equals(splashViewed)) {
            UIManager.INSTANCE.openSplash(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        try {
            class_4597.class_4598 buffers = graphics.method_51450();
            this.method_25420(graphics, mouseX, mouseY, partialTicks);
            this.drawMap(graphics, buffers, mouseX, mouseY);
            if (buttonsVisible) {
                this.drawLogo(graphics);
            }
            this.renderTimer.start();
            this.layoutButtons(graphics);
            List<class_5481> tooltip = null;
            if (this.firstLayoutPass) {
                this.layoutButtons(graphics);
                this.updateMapType(state.getMapType());
                this.firstLayoutPass = false;
            } else if (buttonsVisible) {
                for (int k = 0; k < this.getRenderables().size(); ++k) {
                    Button button;
                    class_4185 guibutton = (class_4185)this.getRenderables().get(k);
                    guibutton.method_25394(graphics, mouseX, mouseY, partialTicks);
                    if (tooltip != null || !(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(this.mx, this.my)) continue;
                    tooltip = button.getWrappedTooltip();
                }
            }
            if (this.chat != null) {
                this.chat.method_25394(graphics, mouseX, mouseY, partialTicks);
            }
            if (tooltip == null || tooltip.isEmpty()) {
                tooltip = this.entityTooltip;
            }
            if (tooltip != null && !tooltip.isEmpty()) {
                this.renderWrappedToolTip(graphics, tooltip, this.mx, this.my, this.getFontRenderer());
                this.entityTooltip = null;
            }
        }
        catch (Exception e) {
            this.logger.log(Level.ERROR, "Unexpected exception in jm.fullscreen.render(): " + LogFormatter.toString(e));
            UIManager.INSTANCE.closeAll();
        }
        finally {
            this.renderTimer.stop();
        }
    }

    public void queueToolTip(List<class_2561> tooltips) {
        this.entityTooltip = tooltips.stream().map(class_2561::method_30937).collect(Collectors.toList());
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
        mapRenderer.clear();
    }

    @Override
    public void method_25423(class_310 minecraft, int width, int height) {
        super.method_25423(minecraft, width, height);
        state.requireRefresh();
        if (this.chat == null) {
            this.chat = new MapChat("", true);
        }
        if (this.chat != null) {
            this.chat.method_25423(minecraft, width, height);
        }
        this.method_25426();
        this.refreshState();
        this.method_16014(0.0, 0.0);
    }

    void initButtons() {
        if (this.getRenderables().isEmpty()) {
            try {
                this.firstLayoutPass = true;
                Theme theme = ThemeLoader.getCurrentTheme();
                MapType mapType = state.getMapType();
                this.bgColor = theme.fullscreen.background.getColor();
                this.statusLabelSpec = theme.fullscreen.statusLabel;
                this.buttonDay = (ThemeButton)this.method_37063((class_364)new ThemeToggle(theme, "jm.fullscreen.map_day", "day", button -> {
                    if (this.buttonDay.isEnabled()) {
                        this.updateMapType(MapType.day(state.getDimension()));
                    }
                }));
                this.buttonDay.setToggled(mapType.isDay(), false);
                this.buttonDay.setStaysOn(true);
                this.buttonNight = (ThemeButton)this.method_37063((class_364)new ThemeToggle(theme, "jm.fullscreen.map_night", "night", button -> {
                    if (this.buttonNight.isEnabled()) {
                        this.updateMapType(MapType.night(state.getDimension()));
                    }
                }));
                this.buttonNight.setToggled(mapType.isNight(), false);
                this.buttonNight.setStaysOn(true);
                this.buttonTopo = (ThemeButton)this.method_37063((class_364)new ThemeToggle(theme, "jm.fullscreen.map_topo", "topo", button -> {
                    if (this.buttonTopo.isEnabled()) {
                        this.updateMapType(MapType.topo(state.getDimension()));
                    }
                }));
                this.buttonTopo.setDrawButton(this.coreProperties.mapTopography.get());
                this.buttonTopo.setToggled(mapType.isTopo(), false);
                this.buttonTopo.setStaysOn(true);
                this.buttonBiome = (ThemeButton)this.method_37063((class_364)new ThemeToggle(theme, "jm.fullscreen.map_biome", "biome", button -> {
                    if (this.buttonBiome.isEnabled()) {
                        this.updateMapType(MapType.biome(state.getDimension()));
                    }
                }));
                this.buttonBiome.setDrawButton(this.coreProperties.mapBiome.get());
                this.buttonBiome.setToggled(mapType.isBiome(), false);
                this.buttonBiome.setStaysOn(true);
                this.buttonLayers = (ThemeButton)this.method_37063((class_364)new ThemeToggle(theme, "jm.fullscreen.map_cave_layers", "layers", button -> {
                    EntityDTO player = DataCache.getPlayer();
                    this.buttonLayers.toggle();
                    this.sliderCaveLayer.setDrawButton(this.buttonLayers.getToggled());
                }));
                this.buttonLayers.setEnabled(state.isCaveMappingAllowed());
                this.buttonLayers.setDrawButton(state.isCaveMappingAllowed());
                class_327 fontRenderer = this.getFontRenderer();
                this.sliderCaveLayer = (IntSliderButton)this.method_37060((class_4068)new IntSliderButton(state.getLastSlice(), Constants.getString("jm.fullscreen.map_cave_layers.button") + " ", ""));
                this.sliderCaveLayer.method_25358(this.sliderCaveLayer.getFitWidth(fontRenderer) + fontRenderer.method_1727("0"));
                this.sliderCaveLayer.setDefaultStyle(false);
                this.sliderCaveLayer.setDrawBackground(true);
                Theme.Control.ButtonSpec buttonSpec = this.buttonLayers.getButtonSpec();
                this.sliderCaveLayer.setBackgroundColors(buttonSpec.buttonDisabled.getColor(), buttonSpec.buttonOff.getColor(), buttonSpec.buttonOff.getColor());
                this.sliderCaveLayer.setLabelColors(buttonSpec.iconHoverOff.getColor(), buttonSpec.iconHoverOn.getColor(), buttonSpec.iconDisabled.getColor());
                this.sliderCaveLayer.setDrawButton(false);
                this.sliderCaveLayer.addClickListener(button -> {
                    state.setMapType(MapType.underground(this.sliderCaveLayer.getValue(), state.getDimension()));
                    state.setForceRefreshState(true);
                    return true;
                });
                this.getRenderables().add((class_4068)this.sliderCaveLayer);
                this.buttonSearch = (ThemeButton)this.method_37063((class_364)new ThemeButton(theme, "jm.fullscreen.search", "search", button -> {
                    this.buttonSearch.toggle();
                    this.toggleSearchBar(this.buttonSearch.getToggled());
                }));
                this.searchTextX = (FullscreenTextBoxButton)this.method_37063((class_364)new FullscreenTextBoxButton("x:", fontRenderer, 40, 20));
                this.searchTextZ = (FullscreenTextBoxButton)this.method_37063((class_364)new FullscreenTextBoxButton("z:", fontRenderer, 40, 20));
                this.buttonExecuteSearch = (ThemeButton)this.method_37063((class_364)new ThemeButton(theme, "jm.fullscreen.search_execute", "follow", button -> this.executeSearch()));
                this.searchTextX.setVisible(false);
                this.searchTextZ.setVisible(false);
                this.buttonExecuteSearch.setVisible(false);
                this.buttonFollow = (ThemeButton)this.method_37063((class_364)new ThemeButton(theme, "jm.fullscreen.follow", "follow", button -> this.toggleFollow()));
                this.buttonZoomIn = (ThemeButton)this.method_37063((class_364)new ThemeButton(theme, "jm.fullscreen.zoom_in", "zoomin", button -> this.zoomIn()));
                this.buttonZoomIn.setEnabled(this.fullMapProperties.zoomLevel.get() < Fullscreen.state.maxZoom);
                this.buttonZoomIn.setDisplayClickToggle(false);
                this.buttonZoomOut = (ThemeButton)this.method_37063((class_364)new ThemeButton(theme, "jm.fullscreen.zoom_out", "zoomout", button -> this.zoomOut()));
                this.buttonZoomOut.setEnabled(this.fullMapProperties.zoomLevel.get() > Fullscreen.state.minZoom);
                this.buttonZoomOut.setDisplayClickToggle(false);
                this.buttonWaypointManager = (ThemeButton)this.method_37063((class_364)new ThemeButton(theme, "jm.waypoint.waypoints_button", "waypoints", button -> UIManager.INSTANCE.openWaypointManager(null, this)));
                this.buttonWaypointManager.setEnabled(WaypointsData.isManagerEnabled());
                this.buttonWaypointManager.setDrawButton(WaypointsData.isManagerEnabled());
                this.buttonOptions = (ThemeButton)this.method_37063((class_364)new ThemeButton(theme, "jm.common.options_button", "options", button -> {
                    try {
                        UIManager.INSTANCE.openOptionsManager((class_437)this, new Category[0]);
                        this.method_37067();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }));
                String versionAvailable = Constants.getString("jm.common.new_version_available", VersionCheck.getVersionAvailable());
                this.buttonAlert = (ThemeButton)this.method_37063((class_364)new ThemeButton(theme, versionAvailable, versionAvailable, false, "alert", button -> {
                    FullscreenActions.launchDownloadWebsite();
                    this.buttonAlert.setDrawButton(false);
                }));
                this.buttonAlert.setDrawButton(VersionCheck.getVersionIsChecked() != false && VersionCheck.getVersionIsCurrent() == false);
                this.buttonAlert.setToggled(true);
                this.buttonClose = (ThemeButton)this.method_37063((class_364)new ThemeButton(theme, "jm.common.close", "close", button -> UIManager.INSTANCE.closeAll()));
                StringField themeField = JourneymapClient.getInstance().getCoreProperties().themeName;
                this.buttonTheme = (FullscreenThemeDropdownButton)this.method_37063((class_364)new FullscreenThemeDropdownButton(fontRenderer, themeField, this.buttonThemeNeedReopen, button -> {
                    UIManager.INSTANCE.getMiniMap().reset();
                    this.method_37067();
                    this.buttonThemeNeedReopen = true;
                }));
                this.buttonThemeNeedReopen = false;
                this.buttonTheme.setVisible(this.fullMapProperties.showThemeButton.get());
                this.buttonCaves = (ThemeButton)this.method_37063((class_364)new ThemeToggle(theme, "jm.common.show_caves", "caves", this.fullMapProperties.showCaves, button -> {
                    EntityDTO player = DataCache.getPlayer();
                    this.buttonCaves.setToggled(this.buttonCaves.getToggled() == false);
                    if (this.buttonCaves.getToggled().booleanValue()) {
                        this.updateMapType(MapType.underground(player));
                    } else {
                        this.updateMapType(MapType.day(player));
                    }
                }));
                this.buttonCaves.setTooltip(Constants.getString("jm.common.show_caves.tooltip"));
                this.buttonCaves.setDrawButton(state.isCaveMappingAllowed());
                this.buttonMobs = (ThemeButton)this.method_37063((class_364)new ThemeToggle(theme, "jm.common.show_mobs", "monsters", this.fullMapProperties.showMobs, button -> this.buttonMobs.toggle()));
                this.buttonMobs.setTooltip(Constants.getString("jm.common.show_mobs.tooltip"));
                this.buttonMobs.setDrawButton(FeatureManager.getInstance().isAllowed(Feature.RadarMobs));
                this.buttonAnimals = (ThemeButton)this.method_37063((class_364)new ThemeToggle(theme, "jm.common.show_animals", "animals", this.fullMapProperties.showAnimals, button -> this.buttonAnimals.toggle()));
                this.buttonAnimals.setTooltip(Constants.getString("jm.common.show_animals.tooltip"));
                this.buttonAnimals.setDrawButton(FeatureManager.getInstance().isAllowed(Feature.RadarAnimals));
                this.buttonPets = (ThemeButton)this.method_37063((class_364)new ThemeToggle(theme, "jm.common.show_pets", "pets", this.fullMapProperties.showPets, button -> this.buttonPets.toggle()));
                this.buttonPets.setTooltip(Constants.getString("jm.common.show_pets.tooltip"));
                this.buttonPets.setDrawButton(FeatureManager.getInstance().isAllowed(Feature.RadarAnimals));
                this.buttonVillagers = (ThemeButton)this.method_37063((class_364)new ThemeToggle(theme, "jm.common.show_villagers", "villagers", this.fullMapProperties.showVillagers, button -> this.buttonVillagers.toggle()));
                this.buttonVillagers.setTooltip(Constants.getString("jm.common.show_villagers.tooltip"));
                this.buttonVillagers.setDrawButton(FeatureManager.getInstance().isAllowed(Feature.RadarVillagers));
                this.buttonPlayers = (ThemeButton)this.method_37063((class_364)new ThemeToggle(theme, "jm.common.show_players", "players", this.fullMapProperties.showPlayers, button -> this.buttonPlayers.toggle()));
                this.buttonPlayers.setTooltip(Constants.getString("jm.common.show_players.tooltip"));
                this.buttonPlayers.setDrawButton(!this.minecraft.method_1496() && FeatureManager.getInstance().isAllowed(Feature.RadarPlayers));
                this.buttonGrid = (ThemeButton)this.method_37063((class_364)new ThemeToggle(theme, "jm.common.show_grid", "grid", this.fullMapProperties.showGrid, button -> {
                    boolean shiftDown;
                    this.buttonGrid.toggle();
                    boolean bl = shiftDown = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)340) || class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)344);
                    if (shiftDown) {
                        UIManager.INSTANCE.openGridEditor(this);
                        this.buttonGrid.setValue(true);
                    }
                }));
                this.buttonGrid.setTooltip(Constants.getString("jm.common.show_grid_shift.tooltip"));
                this.buttonKeys = (ThemeButton)this.method_37063((class_364)new ThemeToggle(theme, "jm.common.show_keys", "keys", this.fullMapProperties.showKeys, button -> this.buttonKeys.toggle()));
                this.buttonKeys.setTooltip(Constants.getString("jm.common.show_keys.tooltip"));
                this.buttonAbout = (ThemeButton)this.method_37063((class_364)new ThemeButton(theme, "jm.common.splash_about", "about", button -> UIManager.INSTANCE.openSplash(this)));
                this.overlayRenderButton = new ThemeButton(theme, "region display on", " region display off", false, "server", button -> RegionRenderer.render(!RegionRenderer.TOGGLED));
                this.method_37063((class_364)this.overlayRenderButton);
                this.buttonSavemap = (ThemeButton)this.method_37063((class_364)new ThemeButton(theme, "jm.common.save_map", "savemap", button -> {
                    this.buttonSavemap.setEnabled(false);
                    try {
                        MapSaver mapSaver = new MapSaver(state.getWorldDir(), state.getMapType());
                        if (mapSaver.isValid()) {
                            JourneymapClient.getInstance().toggleTask(SaveMapTask.Manager.class, true, mapSaver);
                            ChatLog.announceI18N("jm.common.save_filename", mapSaver.getSaveFileName());
                        }
                    }
                    finally {
                        this.buttonSavemap.setToggled(false);
                        this.buttonSavemap.setEnabled(true);
                    }
                }));
                this.buttonBrowser = (ThemeButton)this.method_37063((class_364)new ThemeButton(theme, "jm.common.use_browser", "browser", button -> FullscreenActions.launchLocalhost()));
                boolean webMapEnabled = JourneymapClient.getInstance().getWebMap() != null && JourneymapClient.getInstance().getWebMapProperties().enabled.get() != false;
                this.buttonBrowser.setEnabled(webMapEnabled);
                this.buttonBrowser.setDrawButton(webMapEnabled);
                boolean automapRunning = JourneymapClient.getInstance().isTaskManagerEnabled(MapRegionTask.Manager.class);
                String autoMapOn = Constants.getString("jm.common.automap_stop_title");
                String autoMapOff = Constants.getString("jm.common.automap_title");
                this.autoMapOnTooltip = fontRenderer.method_1728((class_5348)Constants.getTranslatedTextComponent("jm.common.automap_stop_text"), 200);
                this.autoMapOffTooltip = fontRenderer.method_1728((class_5348)Constants.getTranslatedTextComponent("jm.common.automap_text"), 200);
                this.buttonAutomap = (ThemeButton)this.method_37063((class_364)new ThemeToggle(theme, autoMapOn, autoMapOff, "automap", button -> {
                    if (!this.buttonAutomap.getToggled().booleanValue()) {
                        UIManager.INSTANCE.open(AutoMapConfirmation.class, this);
                    } else {
                        JourneymapClient.getInstance().toggleTask(MapRegionTask.Manager.class, false, null);
                        this.buttonAutomap.setToggled(false, false);
                        this.method_37067();
                    }
                }));
                this.buttonAutomap.setEnabled(class_310.method_1551().method_1496() && JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get() != false);
                this.buttonAutomap.setToggled(automapRunning, false);
                this.buttonDeletemap = (ThemeButton)this.method_37063((class_364)new ThemeButton(theme, "jm.common.deletemap_title", "delete", button -> UIManager.INSTANCE.open(DeleteMapConfirmation.class, this)));
                this.buttonDeletemap.setAdditionalTooltips(fontRenderer.method_1728((class_5348)Constants.getTranslatedTextComponent("jm.common.deletemap_text"), 200));
                this.buttonDisable = (ThemeButton)this.method_37063((class_364)new ThemeToggle(theme, "jm.common.enable_mapping_false", "disable", button -> {
                    this.buttonDisable.toggle();
                    JourneymapClient.getInstance().getCoreProperties().mappingEnabled.set(this.buttonDisable.getToggled() == false);
                    if (JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get().booleanValue()) {
                        DataCache.INSTANCE.invalidateChunkMDCache();
                        ChatLog.announceI18N("jm.common.enable_mapping_true_text", new Object[0]);
                    } else {
                        JourneymapClient.getInstance().stopMapping();
                        BlockMD.reset();
                        ChatLog.announceI18N("jm.common.enable_mapping_false_text", new Object[0]);
                    }
                }));
                this.buttonColorPalette = (ThemeButton)this.method_37063((class_364)new ThemeButton(theme, "jm.colorpalette.colorpalette_button", "colorpalette", button -> UIManager.INSTANCE.openColorPalette(this)));
                this.mapTypeToolbar = CustomEventDispatcher.getInstance().getMapTypeToolbar(this, theme, this.buttonLayers, this.buttonTopo, this.buttonBiome, this.buttonNight, this.buttonDay);
                this.mapTypeToolbar.addAllButtons(this);
                this.optionsToolbar = new ThemeToolbar(theme, this.buttonCaves, this.buttonMobs, this.buttonAnimals, this.buttonPets, this.buttonVillagers, this.buttonPlayers, this.buttonGrid, this.buttonKeys);
                this.optionsToolbar.addAllButtons(this);
                this.optionsToolbar.field_22764 = false;
                this.menuToolbar = new ThemeToolbar(theme, this.buttonWaypointManager, this.buttonOptions, this.buttonAbout, this.buttonBrowser, this.buttonColorPalette, this.buttonDeletemap, this.buttonSavemap, this.buttonAutomap, this.buttonDisable, this.overlayRenderButton);
                this.menuToolbar.addAllButtons(this);
                this.menuToolbar.field_22764 = false;
                this.zoomToolbar = new ThemeToolbar(theme, this.buttonSearch, this.buttonFollow, this.buttonZoomIn, this.buttonZoomOut);
                this.zoomToolbar.setLayout(ButtonList.Layout.Vertical, ButtonList.Direction.LeftToRight);
                this.zoomToolbar.addAllButtons(this);
                this.searchToolBar = new ThemeToolbar(theme, this.searchTextX, this.searchTextZ, this.buttonExecuteSearch);
                this.searchToolBar.setLayout(ButtonList.Layout.CenteredHorizontal, ButtonList.Direction.LeftToRight);
                this.searchToolBar.addAllButtons(this);
                this.addonToolbar = CustomEventDispatcher.getInstance().getAddonToolbar(this, theme);
                if (this.addonToolbar != null) {
                    this.addonToolbar.setLayout(ButtonList.Layout.CenteredVertical, ButtonList.Direction.LeftToRight);
                    this.addonToolbar.addAllButtons(this);
                }
                this.customToolbars = CustomEventDispatcher.getInstance().getCustomToolBars(this, theme);
                this.getRenderables().add((class_4068)this.buttonAlert);
                this.getRenderables().add((class_4068)this.buttonClose);
                this.getRenderables().add((class_4068)this.buttonTheme);
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Failure to build Fullscreen Map buttons.", t);
            }
        }
    }

    @Override
    protected void layoutButtons(class_332 graphics) {
        this.mx = (int)(this.minecraft.field_1729.method_1603() * (double)this.field_22789 / (double)this.minecraft.method_22683().method_4480());
        this.my = (int)(this.minecraft.field_1729.method_1604() * (double)this.field_22790 / (double)this.minecraft.method_22683().method_4507() - 1.0);
        if (this.buttonDay != null && !this.buttonDay.hasValidTextures()) {
            this.method_37067();
        }
        if (this.getRenderables().isEmpty()) {
            this.initButtons();
        }
        this.menuToolbar.setDrawToolbar(!this.isChatOpen());
        if (this.fullMapProperties.minimalMode.get().booleanValue()) {
            this.buttonNight.setVisible(false);
            this.buttonLayers.setVisible(false);
            this.buttonMobs.setVisible(false);
            this.buttonPets.setVisible(false);
            this.buttonAnimals.setVisible(false);
            this.buttonVillagers.setVisible(false);
            this.buttonGrid.setVisible(false);
            this.buttonKeys.setVisible(false);
            this.buttonTheme.setVisible(false);
            this.buttonAbout.setVisible(false);
            this.buttonColorPalette.setVisible(false);
            this.buttonDeletemap.setVisible(false);
            this.buttonSavemap.setVisible(false);
            this.buttonAutomap.setVisible(false);
            this.buttonDisable.setVisible(false);
            this.buttonSearch.setVisible(false);
            this.buttonZoomIn.setVisible(false);
            this.buttonZoomOut.setVisible(false);
        }
        MapType mapType = state.getMapType();
        this.buttonDay.setEnabled(state.isSurfaceMappingAllowed());
        this.buttonDay.setToggled(this.buttonDay.isEnabled() && mapType.isDay());
        this.buttonNight.setEnabled(state.isSurfaceMappingAllowed());
        this.buttonNight.setToggled(this.buttonNight.isEnabled() && mapType.isNight());
        this.buttonTopo.setEnabled(state.isTopoMappingAllowed());
        this.buttonTopo.setToggled(this.buttonTopo.isEnabled() && mapType.isTopo());
        this.buttonBiome.setEnabled(state.isBiomeMappingAllowed());
        this.buttonBiome.setToggled(this.buttonBiome.isEnabled() && mapType.isBiome());
        this.buttonCaves.setEnabled(state.isCaveMappingAllowed());
        this.buttonCaves.setToggled(this.buttonCaves.isEnabled() && mapType.isUnderground());
        this.buttonFollow.setEnabled(!Fullscreen.state.follow.get());
        boolean automapRunning = JourneymapClient.getInstance().isTaskManagerEnabled(MapRegionTask.Manager.class);
        boolean mappingEnabled = JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get();
        this.buttonDisable.setToggled(!mappingEnabled, false);
        this.buttonAutomap.setToggled(automapRunning, false);
        this.buttonAutomap.setEnabled(mappingEnabled);
        this.buttonAutomap.setAdditionalTooltips(automapRunning ? this.autoMapOnTooltip : this.autoMapOffTooltip);
        this.buttonWaypointManager.setEnabled(WaypointsData.isManagerEnabled());
        this.buttonWaypointManager.setDrawButton(WaypointsData.isManagerEnabled() && !this.isChatOpen());
        boolean webMapEnabled = JourneymapClient.getInstance().getWebMap() != null && JourneymapClient.getInstance().getWebMapProperties().enabled.get() != false;
        this.buttonBrowser.setEnabled(webMapEnabled && mappingEnabled);
        this.buttonBrowser.setDrawButton(webMapEnabled && !this.isChatOpen());
        this.buttonTheme.setDrawButton(!this.isChatOpen());
        this.buttonTheme.setEnabled(!this.isChatOpen());
        this.buttonTheme.setVisible(this.fullMapProperties.showThemeButton.get() != false && this.fullMapProperties.minimalMode.get() == false);
        boolean mainThreadActive = JourneymapClient.getInstance().isMainThreadTaskActive();
        this.overlayRenderButton.setVisible(System.getProperty("journeymap.map_testing") != null);
        int padding = this.mapTypeToolbar.getToolbarSpec().padding;
        this.zoomToolbar.layoutCenteredVertical(this.zoomToolbar.getHMargin(), this.field_22790 / 2, true, padding);
        this.searchToolBar.layoutHorizontal(this.zoomToolbar.getRightX() + 2, this.zoomToolbar.method_46427() + 1, true, 7, true);
        this.searchTextX.method_46421(this.searchTextX.method_46426() + 3);
        this.searchTextZ.method_46421(this.searchTextZ.method_46426() + 2);
        this.buttonExecuteSearch.setDisplayClickToggle(false);
        if (this.addonToolbar != null) {
            this.addonToolbar.layoutCenteredVertical(this.field_22789 - this.addonToolbar.method_25368() - this.zoomToolbar.getHMargin(), this.field_22790 / 2, true, padding);
        }
        int topY = this.mapTypeToolbar.getVMargin();
        int margin = this.mapTypeToolbar.getHMargin();
        this.buttonClose.leftOf(this.field_22789 - this.zoomToolbar.getHMargin()).below(this.mapTypeToolbar.getVMargin());
        this.buttonAlert.leftOf(this.field_22789 - this.zoomToolbar.getHMargin()).below(this.buttonClose, padding);
        this.buttonTheme.rightOf(6).above(this.field_22790 - 6);
        int toolbarsWidth = this.mapTypeToolbar.method_25368() + this.optionsToolbar.method_25368() + margin + padding;
        int startX = (this.field_22789 - toolbarsWidth) / 2;
        Rectangle2D.Double oldBounds = this.mapTypeToolbar.getBounds();
        this.mapTypeToolbar.layoutHorizontal(startX + this.mapTypeToolbar.method_25368(), topY, false, padding);
        if (!this.mapTypeToolbar.getBounds().equals(oldBounds)) {
            this.mapTypeToolbarBounds = null;
        }
        oldBounds = this.optionsToolbar.getBounds();
        this.optionsToolbar.layoutHorizontal(this.mapTypeToolbar.getRightX() + margin, topY, true, padding);
        this.optionsToolbar.field_22764 = true;
        if (!this.optionsToolbar.getBounds().equals(oldBounds)) {
            this.optionsToolbarBounds = null;
        }
        oldBounds = this.menuToolbar.getBounds();
        this.menuToolbar.layoutCenteredHorizontal(this.field_22789 / 2, this.field_22790 - this.menuToolbar.method_25364() - this.menuToolbar.getVMargin(), true, padding);
        if (!this.menuToolbar.getBounds().equals(oldBounds)) {
            this.menuToolbarBounds = null;
        }
        if (this.sliderCaveLayer.isVisible()) {
            this.sliderCaveLayer.below(this.buttonLayers, 1).centerHorizontalOn(this.buttonLayers.getCenterX());
            int slice = this.sliderCaveLayer.getValue();
            int minY = slice << 4;
            int maxY = (slice + 1 << 4) - 1;
            this.sliderCaveLayer.setTooltip(Constants.getString("jm.fullscreen.map_cave_layers.button.tooltip", minY, maxY));
        }
    }

    @Nullable
    public Rectangle2D.Double getOptionsToolbarBounds() {
        if (this.optionsToolbar != null && this.optionsToolbar.isVisible()) {
            Rectangle2D.Double unscaled = this.optionsToolbar.getBounds();
            this.optionsToolbarBounds = new Rectangle2D.Double(unscaled.x * this.scaleFactor, unscaled.y * this.scaleFactor, unscaled.width * this.scaleFactor, unscaled.height * this.scaleFactor);
        }
        return this.optionsToolbarBounds;
    }

    @Nullable
    public Rectangle2D.Double getMenuToolbarBounds() {
        if (this.menuToolbar != null && this.menuToolbar.isVisible()) {
            Rectangle2D.Double unscaled = this.menuToolbar.getBounds();
            this.menuToolbarBounds = new Rectangle2D.Double(unscaled.x * this.scaleFactor, unscaled.y * this.scaleFactor, unscaled.width * this.scaleFactor, unscaled.height * this.scaleFactor);
        }
        return this.menuToolbarBounds;
    }

    public boolean method_25401(double mouseX, double mouseY, double f, double wheel) {
        try {
            if (wheel > 0.0) {
                this.zoomIn();
            } else if (wheel < 0.0) {
                this.zoomOut();
            }
            if (!Fullscreen.state.follow.get()) {
                class_2338 newBlockLoc = this.getBlockAtMouse();
                this.moveCanvas(this.zoomBlock.method_10263() - newBlockLoc.method_10263(), this.zoomBlock.method_10260() - newBlockLoc.method_10260());
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toPartialString(t));
            return false;
        }
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        try {
            if (this.chat != null && !this.chat.isHidden()) {
                this.chat.method_25402(mouseX, mouseY, mouseButton);
            }
            Point2D.Double mousePosition = new Point2D.Double(this.minecraft.field_1729.method_1603(), this.minecraft.field_1729.method_1604());
            this.mx = (int)(this.minecraft.field_1729.method_1603() * (double)this.field_22789 / (double)this.minecraft.method_22683().method_4480());
            this.my = (int)(this.minecraft.field_1729.method_1604() * (double)this.field_22790 / (double)this.minecraft.method_22683().method_4507() - 1.0);
            if (!this.isMouseOverButton(mouseX, mouseY)) {
                if (FullscreenEventDispatcher.clickEventPre(this.getBlockAtMouse(), (class_5321<class_1937>)class_310.method_1551().field_1687.method_27983(), new Point2D.Double(mouseX, mouseY), mouseButton)) {
                    return false;
                }
                this.popupMenu.setClickLoc((int)mouseX, (int)mouseY);
                this.layerDelegate.onMouseClicked(this.minecraft, mapRenderer, mousePosition, mouseButton, this.getMapFontScale());
                FullscreenEventDispatcher.clickEventPost(this.getBlockAtMouse(), (class_5321<class_1937>)class_310.method_1551().field_1687.method_27983(), new Point2D.Double(mouseX, mouseY), mouseButton);
            }
            this.sliderCaveLayer.method_25402(mouseX, mouseY, mouseButton);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toPartialString(t));
        }
        this.popupMenu.resetPass();
        if (this.searchTextX.mouseOver(mouseX, mouseY) || this.searchTextZ.mouseOver(mouseX, mouseY)) {
            boolean zClicked = this.searchTextZ.method_25402(mouseX, mouseY, mouseButton);
            boolean xClicked = this.searchTextX.method_25402(mouseX, mouseY, mouseButton);
            super.method_25395((class_364)(zClicked ? this.searchTextZ : this.searchTextX));
            return true;
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public void method_16014(double mouseX, double mouseY) {
        this.zoomBlock = this.getBlockAtMouse();
        Point2D.Double mousePosition = new Point2D.Double(this.minecraft.field_1729.method_1603(), this.minecraft.field_1729.method_1604());
        this.layerDelegate.onMouseMove(this.minecraft, mapRenderer, mousePosition, this.getMapFontScale(), this.isDragging);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        long sysTime;
        boolean updateGrid;
        this.sliderCaveLayer.method_25403(mouseX, mouseY, button, mouseDX, mouseDY);
        if (this.sliderCaveLayer.dragging || !(this.minecraft.field_1755 instanceof Fullscreen)) {
            this.isDragging = false;
        }
        boolean bl = updateGrid = (sysTime = class_156.method_658()) - this.lastGridUpdate > 200L;
        if (button == 0 && this.isDragging.booleanValue() && updateGrid) {
            this.lastGridUpdate = sysTime;
            this.updateGrid();
        }
        if (button == 0 && !this.isDragging.booleanValue() && !this.isMouseOverButton(mouseX, mouseY)) {
            Point2D.Double mousePosition = new Point2D.Double(this.minecraft.field_1729.method_1603(), this.minecraft.field_1729.method_1604());
            if (FullscreenEventDispatcher.dragEventPre(this.getBlockAtMouse(), (class_5321<class_1937>)class_310.method_1551().field_1687.method_27983(), new Point2D.Double(mouseX, mouseY), button)) {
                return false;
            }
            this.isDragging = !this.sliderCaveLayer.dragging;
            this.mouseDragX = this.mx;
            this.mouseDragY = this.my;
            this.minecraft.field_1729.method_1599();
            this.layerDelegate.onMouseMove(this.minecraft, mapRenderer, mousePosition, this.getMapFontScale(), this.isDragging);
        }
        return super.method_25403(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    private void updateGrid() {
        Point2D.Double drag = this.getMouseDrag();
        this.updateGrid(-drag.getX(), -drag.getY());
    }

    private void updateGrid(double x, double z) {
        this.mouseDragX = this.mx;
        this.mouseDragY = this.my;
        try {
            mapRenderer.move(x, z);
            mapRenderer.updateTiles(state.getMapType(), this.fullMapProperties.zoomLevel.get(), false);
            mapRenderer.setZoom(this.fullMapProperties.zoomLevel.get().intValue());
        }
        catch (Exception e) {
            this.logger.error("Error moving grid: " + String.valueOf(e));
        }
        this.setFollow(false);
        this.refreshState();
    }

    private Point2D.Double getMouseDrag() {
        double blockSize = Fullscreen.uiState().blockSize;
        int dragScale = this.fullMapProperties.dragScale.get();
        double mouseDragX = (double)(this.mx - this.mouseDragX) * this.scaleFactor / blockSize / (double)dragScale;
        double mouseDragY = (double)(this.my - this.mouseDragY) * this.scaleFactor / blockSize / (double)dragScale;
        return new Point2D.Double(mouseDragX, mouseDragY);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        try {
            Point2D.Double mousePosition = new Point2D.Double(this.minecraft.field_1729.method_1603(), this.minecraft.field_1729.method_1604());
            super.method_25406(mouseX, mouseY, button);
            if (this.sliderCaveLayer.isVisible() && this.sliderCaveLayer.dragging) {
                this.sliderCaveLayer.method_25406(mouseX, mouseY, button);
                this.isDragging = false;
                return true;
            }
            if (this.isDragging.booleanValue()) {
                this.isDragging = false;
                this.updateGrid();
                FullscreenEventDispatcher.dragEventPost(this.getBlockAtMouse(), (class_5321<class_1937>)class_310.method_1551().field_1687.method_27983(), new Point2D.Double(mouseX, mouseY), button);
            }
            this.layerDelegate.onMouseMove(this.minecraft, mapRenderer, mousePosition, this.getMapFontScale(), this.isDragging);
            return true;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toPartialString(t));
            return false;
        }
    }

    public void toggleMapType() {
        this.updateMapType(state.toggleMapType());
    }

    public void updateMapType(Context.MapType mapType, Integer vSlice, class_5321<class_1937> dimension) {
        this.updateMapType(MapType.fromApiContextMapType(mapType, vSlice, dimension));
    }

    private void updateMapType(MapType newType) {
        if (!newType.isAllowed()) {
            newType = state.getMapType();
        }
        state.setMapType(newType);
        this.buttonDay.setToggled(newType.isDay(), false);
        this.buttonNight.setToggled(newType.isNight(), false);
        this.buttonBiome.setToggled(newType.isBiome(), false);
        this.buttonTopo.setToggled(newType.isTopo(), false);
        if (newType.isUnderground()) {
            this.sliderCaveLayer.setValue(newType.vSlice);
        }
        mapRenderer.clear();
        state.requireRefresh();
    }

    public void zoomIn() {
        if (this.fullMapProperties.zoomLevel.get() < Fullscreen.state.maxZoom) {
            Integer currentZoom = this.fullMapProperties.zoomLevel.get();
            this.setZoom(currentZoom * 2);
        }
    }

    public void zoomOut() {
        if (this.fullMapProperties.zoomLevel.get() > Fullscreen.state.minZoom) {
            Integer currentZoom = this.fullMapProperties.zoomLevel.get();
            this.setZoom(currentZoom / 2);
        }
    }

    private void setZoom(int zoom) {
        if (state.setZoom(zoom)) {
            mapRenderer.setZoom(zoom);
            this.buttonZoomOut.setEnabled(this.fullMapProperties.zoomLevel.get() > Fullscreen.state.minZoom);
            this.buttonZoomIn.setEnabled(this.fullMapProperties.zoomLevel.get() < Fullscreen.state.maxZoom);
            this.refreshState();
        }
    }

    public void toggleSearchBar(boolean toggled) {
        this.searchToolBar.setEnabled(toggled);
        this.searchToolBar.setVisible(toggled);
        this.buttonSearch.setToggled(toggled);
        this.searchTextZ.setVisible(toggled);
        this.searchTextX.setVisible(toggled);
        this.buttonExecuteSearch.setVisible(toggled);
    }

    void executeSearch() {
        this.buttonExecuteSearch.setToggled(true, false);
        try {
            int x = Integer.parseInt(this.searchTextX.getText().toLowerCase(Locale.ROOT).replace("x:", ""));
            int z = Integer.parseInt(this.searchTextZ.getText().toLowerCase(Locale.ROOT).replace("z:", ""));
            this.centerOn(x, z);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void toggleFollow() {
        boolean isFollow = !Fullscreen.state.follow.get();
        this.setFollow(isFollow);
        if (isFollow && this.minecraft.field_1724 != null) {
            this.sliderCaveLayer.setValue(this.minecraft.field_1724.method_31478() >> 4);
            if (state.getMapType().isUnderground()) {
                this.sliderCaveLayer.checkClickListeners();
            }
        }
    }

    public void setFollow(Boolean follow) {
        Fullscreen.state.follow.set(follow);
        if (follow.booleanValue()) {
            state.resetMapType();
            this.refreshState();
        }
        ClientAPI.INSTANCE.flagOverlaysForRerender();
    }

    public class_2338 getBlockAtMouse() {
        Point2D.Double mousePosition = new Point2D.Double(this.minecraft.field_1729.method_1603(), this.minecraft.field_1729.method_1604());
        return this.layerDelegate.getBlockPos(this.minecraft, mapRenderer, mousePosition);
    }

    public void createWaypointAtMouse() {
        UIManager.INSTANCE.openWaypointEditor(null, this.getBlockAtMouse(), true);
    }

    public void chatPositionAtMouse() {
        ClientWaypointImpl holder = WaypointFactoryImpl.at(this.getBlockAtMouse(), false, state.getDimension().method_29177().toString());
        this.chatOpenedFromEvent = true;
        this.openChat(holder.toChatString());
    }

    public boolean isChatOpen() {
        return this.chat != null && !this.chat.isHidden();
    }

    @Override
    public boolean method_25404(int key, int value, int modifier) {
        switch (key) {
            case 256: {
                if (this.isChatOpen()) {
                    this.chat.close();
                } else {
                    UIManager.INSTANCE.closeAll();
                }
                return true;
            }
        }
        long windowId = class_310.method_1551().method_22683().method_4490();
        if (this.minecraft.field_1690.field_1890.method_1417(key, value) && !this.isChatOpen() && !class_3675.method_15987((long)windowId, (int)292)) {
            this.chatOpenedFromEvent = true;
            this.openChat("");
            return true;
        }
        if (this.minecraft.field_1690.field_1845.method_1417(key, value) && !this.isChatOpen() && !class_3675.method_15987((long)windowId, (int)292)) {
            this.chatOpenedFromEvent = true;
            this.openChat("/");
            return true;
        }
        if (this.isChatOpen()) {
            this.chat.method_25404(key, value, modifier);
        }
        return super.method_25404(key, value, modifier);
    }

    @Override
    public boolean method_25400(char typedChar, int keyCode) {
        if (this.isChatOpen() && this.chatOpenedFromEvent) {
            this.chatOpenedFromEvent = false;
            return false;
        }
        if (this.searchTextX != null && this.searchTextZ != null) {
            if (this.searchTextX.method_25367() && !this.isChatOpen()) {
                return this.searchTextX.method_25400(typedChar, keyCode);
            }
            if (this.searchTextZ.method_25367() && !this.isChatOpen()) {
                return this.searchTextZ.method_25400(typedChar, keyCode);
            }
            return this.chat.method_25400(typedChar, keyCode);
        }
        return super.method_25400(typedChar, keyCode);
    }

    public boolean isSearchFocused() {
        return this.searchTextX.method_25367() || this.searchTextZ.method_25367();
    }

    public void method_25393() {
        super.method_25393();
        if (this.chat != null) {
            this.chat.method_25393();
        }
    }

    @Override
    public void method_25420(class_332 graphics, int i, int j, float f) {
        DrawUtil.drawRectangle(graphics, 0.0, 0.0, this.field_22789, this.field_22790, this.bgColor, 1.0f);
        DrawUtil.drawRectangle(graphics, 0.0, 0.0, this.field_22789, this.field_22790, 0x222222, 0.8f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawMap(class_332 graphics, class_4597.class_4598 buffers, int mouseX, int mouseY) {
        boolean refreshReady = this.isRefreshReady();
        StatTimer timer = refreshReady ? this.drawMapTimerWithRefresh : this.drawMapTimer;
        MapType mapType = state.getMapType();
        timer.start();
        try {
            Point2D.Double playerPixel;
            this.sizeDisplay(false);
            double xOffset = 0.0;
            double yOffset = 0.0;
            if (this.isDragging.booleanValue()) {
                Point2D.Double drag = this.getMouseDrag();
                double blockSize = Fullscreen.uiState().blockSize;
                double mouseDragX = drag.getX();
                double mouseDragY = drag.getY();
                xOffset = mouseDragX * blockSize;
                yOffset = mouseDragY * blockSize;
            } else if (refreshReady) {
                this.refreshState();
            } else {
                mapRenderer.setContext(state);
            }
            mapRenderer.clearGlErrors(false);
            mapRenderer.updateRotation(graphics, 0.0);
            class_243 playerCamera = this.minecraft.field_1773.method_19418().method_19326();
            if (Fullscreen.state.follow.get()) {
                mapRenderer.center(state.getWorldDir(), mapType, playerCamera.method_10216(), playerCamera.method_10215(), this.fullMapProperties.zoomLevel.get());
                ClientAPI.INSTANCE.flagOverlaysForRerender();
            }
            mapRenderer.updateTiles(state.getMapType(), this.fullMapProperties.zoomLevel.get(), false);
            mapRenderer.render(graphics, buffers, xOffset, yOffset, 0.8f, this.fullMapProperties.showGrid.get());
            mapRenderer.draw(graphics, buffers, state.getDrawSteps(), this, (int)((double)mouseX + xOffset), (int)((double)mouseY + yOffset), xOffset, yOffset, this.getMapFontScale(), 0.0);
            mapRenderer.draw(graphics, buffers, state.getDrawWaypointSteps(), xOffset, yOffset, (double)this.getMapFontScale(), 0.0);
            if (this.fullMapProperties.showSelf.get().booleanValue() && (playerPixel = mapRenderer.getPixel(playerCamera.method_10216(), playerCamera.method_10215())) != null) {
                float scale = this.fullMapProperties.selfDisplayScale.get().floatValue();
                graphics.method_51448().method_46416(0.0f, 0.0f, 1000.0f);
                class_1043 bgTex = TextureCache.getTexture(TextureCache.PlayerArrowBG);
                class_1921 renderType = JMRenderTypes.getIcon((class_1044)bgTex);
                class_4588 vertexBuilder = buffers.getBuffer(renderType);
                DrawUtil.drawColoredEntity(graphics.method_51448(), vertexBuilder, bgTex, 0xFFFFFF, 1.0f, ((Point2D)playerPixel).getX() + xOffset, ((Point2D)playerPixel).getY() + yOffset, scale / 5.0f, -this.minecraft.field_1773.method_19418().method_19330());
                int playerColor = this.coreProperties.getColor(this.coreProperties.colorSelf);
                class_1043 fgTex = TextureCache.getTexture(TextureCache.PlayerArrow);
                class_1921 renderType2 = JMRenderTypes.getIcon((class_1044)fgTex);
                class_4588 vertexBuilder2 = buffers.getBuffer(renderType2);
                DrawUtil.drawColoredEntity(graphics.method_51448(), vertexBuilder2, fgTex, playerColor, 1.0f, ((Point2D)playerPixel).getX() + xOffset, ((Point2D)playerPixel).getY() + yOffset, scale / 5.0f, -this.minecraft.field_1773.method_19418().method_19330());
                graphics.method_51448().method_46416(0.0f, 0.0f, -1000.0f);
            }
            mapRenderer.draw(graphics, buffers, this.layerDelegate.getDrawSteps(), xOffset, yOffset, (double)this.getMapFontScale(), 0.0);
            this.sizeDisplay(true);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Journeymap.getLogger().error("Error drawing something on the fullscreen map.", t);
        }
        finally {
            timer.stop();
            mapRenderer.clearGlErrors(true);
        }
    }

    private float getMapFontScale() {
        return this.fullMapProperties.fontScale.get().floatValue();
    }

    public void centerOn(ClientWaypointImpl holder) {
        if (holder.isInPlayerDimension()) {
            if (!holder.isPersistent()) {
                this.addTempMarker(holder);
            }
            this.centerOn(holder.getX(), holder.getZ());
        }
    }

    public void centerOn(double x, double z) {
        Fullscreen.state.follow.set(false);
        state.requireRefresh();
        mapRenderer.center(state.getWorldDir(), state.getMapType(), x, z, this.fullMapProperties.zoomLevel.get());
        this.refreshState();
        this.method_25393();
        ClientAPI.INSTANCE.flagOverlaysForRerender();
    }

    public void addTempMarker(ClientWaypointImpl waypoint) {
        try {
            class_2338 pos = waypoint.getBlockPos();
            PolygonOverlay polygonOverlay = new PolygonOverlay("journeymap", this.minecraft.field_1724.method_5770().method_27983(), new ShapeProperties().setStrokeColor(255).setStrokeOpacity(1.0f).setStrokeWidth(1.5f), new MapPolygon(new class_2338[]{pos.method_10069(-1, 0, 2), pos.method_10069(2, 0, 2), pos.method_10069(2, 0, -1), pos.method_10069(-1, 0, -1)}));
            polygonOverlay.setActiveMapTypes(Context.MapType.all());
            polygonOverlay.setActiveUIs(new Context.UI[]{Context.UI.Fullscreen});
            polygonOverlay.setLabel(waypoint.getName());
            this.tempOverlays.add((Overlay)polygonOverlay);
            ClientAPI.INSTANCE.show((Displayable)polygonOverlay);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error showing temp location marker: " + LogFormatter.toPartialString(t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshState() {
        class_746 player = this.minecraft.field_1724;
        if (player == null) {
            this.logger.warn("Could not get player");
            return;
        }
        StatTimer timer = StatTimer.get("Fullscreen.refreshState");
        timer.start();
        try {
            this.menuToolbarBounds = null;
            this.optionsToolbarBounds = null;
            this.fullMapProperties = JourneymapClient.getInstance().getFullMapProperties();
            state.refresh(this.minecraft, (class_1657)player, this.fullMapProperties);
            MapType mapType = state.getMapType();
            mapRenderer.setContext(state);
            if (Fullscreen.state.follow.get()) {
                mapRenderer.center(state.getWorldDir(), mapType, this.minecraft.field_1724.method_23317(), this.minecraft.field_1724.method_23321(), this.fullMapProperties.zoomLevel.get());
            } else {
                mapRenderer.setZoom(this.fullMapProperties.zoomLevel.get().intValue());
            }
            mapRenderer.updateTiles(state.getMapType(), this.fullMapProperties.zoomLevel.get(), true);
            mapRenderer.updateUIState(true);
            state.generateDrawSteps(this.minecraft, mapRenderer, this.waypointRenderer, this.radarRenderer, this.fullMapProperties, false);
            LocationFormat.LocationFormatKeys locationFormatKeys = this.locationFormat.getFormatKeys(this.fullMapProperties.locationFormat.get());
            Fullscreen.state.playerLastPos = locationFormatKeys.format(this.fullMapProperties.locationFormatVerbose.get(), class_3532.method_15357((double)this.minecraft.field_1724.method_23317()), class_3532.method_15357((double)this.minecraft.field_1724.method_23321()), class_3532.method_15357((double)this.minecraft.field_1724.method_5829().field_1322), this.minecraft.field_1724.method_31478() >> 4) + " " + state.getPlayerBiome();
            state.updateLastRefresh();
        }
        finally {
            timer.stop();
        }
    }

    public void openChat(String defaultText) {
        if (this.chat != null) {
            this.chat.setText(defaultText);
            this.chat.setHidden(false);
        } else {
            this.chat = new MapChat(defaultText, false);
            this.chat.method_25410(this.minecraft, this.field_22789, this.field_22790);
        }
    }

    public void close() {
        for (Overlay temp : this.tempOverlays) {
            ClientAPI.INSTANCE.remove((Displayable)temp);
        }
        mapRenderer.updateUIState(false);
        if (this.chat != null) {
            this.chat.close();
        }
    }

    public void method_25432() {
    }

    boolean isRefreshReady() {
        if (this.isDragging.booleanValue()) {
            return false;
        }
        return state.shouldRefresh(super.getMinecraft(), this.fullMapProperties) || mapRenderer.hasUnloadedTile();
    }

    public double getScreenScaleFactor() {
        return this.scaleFactor;
    }

    public int getZoom() {
        return mapRenderer.getZoom();
    }

    public void moveCanvas(double deltaBlockX, double deltaBlockZ) {
        this.refreshState();
        mapRenderer.move(deltaBlockX, deltaBlockZ);
        mapRenderer.updateTiles(state.getMapType(), this.fullMapProperties.zoomLevel.get(), true);
        ClientAPI.INSTANCE.flagOverlaysForRerender();
        this.setFollow(false);
    }

    public void showCaveLayers() {
        if (!state.isUnderground()) {
            this.updateMapType(MapType.underground(3, state.getDimension()));
        }
    }

    @Override
    protected void drawLogo(class_332 graphics) {
        if (!((TextureAccess)this.logo).journeymap$hasImage()) {
            this.logo = TextureCache.getTexture(TextureCache.Logo);
        }
        DrawUtil.sizeDisplay(this.minecraft.method_22683().method_4480(), this.minecraft.method_22683().method_4507());
        Theme.Container.Toolbar toolbar = ThemeLoader.getCurrentTheme().container.toolbar;
        double scale = this.scaleFactor * 2.0;
        DrawUtil.sizeDisplay(this.field_22789, this.field_22790);
        DrawUtil.drawImage(graphics.method_51448(), this.logo, toolbar.horizontal.margin, toolbar.vertical.margin, false, (float)(1.0 / scale), 0.0);
    }

    @Override
    public final boolean method_25421() {
        return false;
    }

    public void setTheme(String name) {
        try {
            MiniMapProperties mmp = JourneymapClient.getInstance().getMiniMapProperties(JourneymapClient.getInstance().getActiveMinimapId());
            mmp.shape.set(Shape.Rectangle);
            mmp.sizePercent.set((Object)20);
            mmp.save();
            Theme theme = ThemeLoader.getThemeByName(name);
            ThemeLoader.setCurrentTheme(theme);
            UIManager.INSTANCE.getMiniMap().reset();
            ChatLog.announceI18N("jm.common.ui_theme_applied", new Object[0]);
            UIManager.INSTANCE.closeAll();
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Could not load Theme: " + LogFormatter.toString(e));
        }
    }

    public void addButtonWidget(Button button) {
        this.method_37063((class_364)button);
    }

    public MapType getMapType() {
        return mapRenderer.getMapType();
    }

    public void hideButtons() {
        buttonsVisible = !buttonsVisible;
    }

    public boolean isButtonsVisable() {
        return buttonsVisible;
    }

    public void toggleEntityNames() {
        this.fullMapProperties.showEntityNames.toggle();
    }
}

