/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.events;

import commonnetwork.api.Network;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.UUID;
import journeymap.api.services.Services;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.mixin.server.ChunkMapAccessor;
import journeymap.common.mixin.server.ServerChunkCacheAccessor;
import journeymap.common.nbt.PlayerData;
import journeymap.common.network.packets.ChunkOverlayPacket;
import journeymap.common.network.packets.RemovePlayerPacket;
import journeymap.common.properties.GlobalProperties;
import journeymap.common.properties.PropertiesManager;
import journeymap.common.properties.ServerOption;
import journeymap.common.util.LoadedChunksToPoints;
import journeymap.common.util.PermissionsManager;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3898;

public class ServerEventHandler {
    private static int playerUpdateTicksCount = 0;
    private static int loadedChunkTickCount = 0;

    public void onServerTickEvent(class_1937 world) {
        ++loadedChunkTickCount;
        if (((ServerOption)((Object)PropertiesManager.getInstance().getGlobalProperties().worldPlayerRadar.get())).enabled()) {
            int playerUpdateTicks = PropertiesManager.getInstance().getGlobalProperties().worldPlayerRadarUpdateTime.get();
            if (world != null && ++playerUpdateTicksCount >= playerUpdateTicks) {
                this.sendPlayersOnRadarToPlayers();
                playerUpdateTicksCount = 0;
            }
        }
        if (world != null && loadedChunkTickCount >= 60) {
            loadedChunkTickCount = 0;
            class_3898 chunkMap = ((ServerChunkCacheAccessor)world.method_8398()).getChunkMap();
            Iterable<class_3193> chunks = ((ChunkMapAccessor)chunkMap).invokeGetChunks();
            LoadedChunksToPoints.PolygonData chunkData = LoadedChunksToPoints.recalculateChunks(chunks);
            world.method_8503().method_3760().method_14571().forEach(player -> {
                if (world.method_8503().method_3760().method_14569(player.method_7334())) {
                    PlayerData.Player pData = PlayerData.getPlayerData().getPlayer((class_3222)player);
                    Network.getNetworkHandler().sendToClient((Object)new ChunkOverlayPacket(new LoadedChunksToPoints.PolygonData(pData.viewChunkFull() ? chunkData.full() : null, pData.viewChunkEntity() ? chunkData.entity() : null, pData.viewChunkBlock() ? chunkData.block() : null, pData.viewChunkInaccessible() ? chunkData.inaccessible() : null).toJsonString()), player);
                }
            });
        }
    }

    public void onEntityJoinWorldEvent(class_1297 entity) {
        if (entity instanceof class_3222) {
            this.sendConfigsToPlayer((class_3222)entity);
        }
    }

    public void onPlayerLoggedInEvent(class_1657 player) {
        if (player instanceof class_3222) {
            Journeymap.getInstance().getDispatcher().sendHandshakePacket((class_3222)player, Journeymap.JM_VERSION.toJson());
            this.sendConfigsToPlayer((class_3222)player);
            PlayerData.getPlayerData().getPlayer((class_3222)player);
        }
    }

    public void sendConfigsToPlayer(class_3222 player) {
        PermissionsManager.getInstance().sendPermissions(player);
    }

    private void sendPlayersOnRadarToPlayers() {
        GlobalProperties prop = PropertiesManager.getInstance().getGlobalProperties();
        ServerOption option = (ServerOption)((Object)prop.worldPlayerRadar.get());
        for (class_3222 player : Services.COMMON_SERVICE.getServer().method_3760().method_14571()) {
            boolean playerRadarEnabled = PropertiesManager.getInstance().getDimProperties(DimensionHelper.getDimension((class_1297)player)).playerRadarEnabled.get();
            boolean receiverOp = Services.COMMON_SERVICE.isOp((class_1657)player);
            if ((!option.enabled() || !playerRadarEnabled) && (!option.canOps() || !receiverOp)) continue;
            try {
                this.sendPlayerTrackingData(player, receiverOp);
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
    }

    private void sendPlayerTrackingData(class_3222 entityPlayerMP, boolean receiverOp) {
        List serverPlayers = entityPlayerMP.field_13995.method_3760().method_14571();
        if (serverPlayers != null && serverPlayers.size() > 1) {
            GlobalProperties properties = PropertiesManager.getInstance().getGlobalProperties();
            for (class_3222 radarPlayer : serverPlayers) {
                boolean sameDimension = entityPlayerMP.method_5770().method_27983().equals(radarPlayer.method_5770().method_27983());
                boolean sneaking = radarPlayer.method_5715();
                boolean invisible = radarPlayer.method_5756((class_1657)entityPlayerMP);
                boolean hideOp = properties.hideOps.get();
                boolean hideSpectators = properties.hideSpectators.get() != false && radarPlayer.method_7325();
                boolean seeUnderground = this.seeUnderground(radarPlayer, receiverOp);
                boolean visible = sameDimension && (receiverOp && seeUnderground || !hideOp && !sneaking && !hideSpectators && !invisible && seeUnderground);
                boolean bl = visible = visible && this.isSelfHidden(radarPlayer, properties, receiverOp);
                if (visible) {
                    visible = entityPlayerMP.method_51469().method_18456().contains(radarPlayer);
                }
                UUID playerId = radarPlayer.method_5667();
                if (entityPlayerMP.method_5667().equals(playerId) || !entityPlayerMP.field_13987.method_48106()) continue;
                Journeymap.getInstance().getDispatcher().sendPlayerLocationPacket(entityPlayerMP, radarPlayer, visible);
            }
        }
    }

    private boolean isSelfHidden(class_3222 radarPlayer, GlobalProperties properties, boolean receiverOp) {
        if (((ServerOption)((Object)properties.allowMultiplayerSettings.get())).hasOption(receiverOp) || ServerOption.OPS.equals(properties.allowMultiplayerSettings.get())) {
            PlayerData.Player player = PlayerData.getPlayerData().getPlayer(radarPlayer);
            boolean hiddenUnderground = player.isHiddenUnderground() && this.isUnderground(radarPlayer) && !class_1937.field_25180.equals(radarPlayer.method_5770().method_27983());
            return receiverOp || player.isVisible() && !hiddenUnderground;
        }
        return true;
    }

    private boolean seeUnderground(class_3222 player, boolean isOp) {
        ServerOption seeUnderground = (ServerOption)((Object)PropertiesManager.getInstance().getGlobalProperties().seeUndergroundPlayers.get());
        if (!class_1937.field_25180.equals(player.method_5770().method_27983()) && !ServerOption.ALL.equals((Object)seeUnderground) && this.isUnderground(player)) {
            return seeUnderground.hasOption(isOp);
        }
        return true;
    }

    private boolean isUnderground(class_3222 player) {
        return !player.method_5770().method_8311(class_2338.method_49638((class_2374)player.method_33571()));
    }

    public void unloadPlayer(class_1297 entity, class_3218 world) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            for (class_3222 onlinePlayer : world.method_8503().method_3760().method_14571()) {
                if (onlinePlayer.method_5667().equals(player.method_5667())) continue;
                Network.getNetworkHandler().sendToAllClients((Object)new RemovePlayerPacket(player.method_5667()), world.method_8503());
            }
        }
    }
}

