/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import journeymap.api.services.Services;
import journeymap.common.util.PermissionsManager;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4284;
import net.minecraft.class_7225;

public class PlayerData
extends class_18 {
    private static final Codec<Player> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("player_id").forGetter(Player::getUuid), (App)Codec.BOOL.fieldOf("hidden_underground").forGetter(Player::isHiddenUnderground), (App)Codec.BOOL.fieldOf("radar_visible").forGetter(Player::isVisible), (App)Codec.BOOL.fieldOf("view_loaded_chunk_entity").forGetter(Player::isChunkEntity), (App)Codec.BOOL.fieldOf("view_loaded_chunk_full").forGetter(Player::isChunkFull), (App)Codec.BOOL.fieldOf("view_loaded_chunk_block").forGetter(Player::isChunkBlock), (App)Codec.BOOL.fieldOf("view_loaded_chunk_inaccessible").forGetter(Player::isChunkInaccessible)).apply((Applicative)instance, Player::new));
    private static final String DAT_FILE = "JMPlayerSettings";
    private class_2487 data = new class_2487();
    Map<String, Player> playerMap = new HashMap<String, Player>();

    public PlayerData() {
        Services.COMMON_SERVICE.getServer().method_3847(class_1937.field_25179).method_17983().method_123(DAT_FILE, (class_18)this);
        this.method_80();
    }

    public static PlayerData getPlayerData() {
        return PlayerData.get();
    }

    public class_2487 method_75(class_2487 compound, class_7225.class_7874 provider) {
        this.playerMap.forEach((uuid, player) -> {
            DataResult result = CODEC.encodeStart((DynamicOps)class_2509.field_11560, player);
            if (result.result().isPresent()) {
                this.data.method_10566(uuid, (class_2520)result.result().get());
            }
        });
        compound.method_10566(DAT_FILE, (class_2520)this.data);
        return compound;
    }

    private static PlayerData get() {
        class_3218 level = Services.COMMON_SERVICE.getServer().method_3847(class_1937.field_25179);
        return (PlayerData)level.method_17983().method_17924(PlayerData.dataFactory(), DAT_FILE);
    }

    private static PlayerData load(class_2487 nbt, class_7225.class_7874 provider) {
        PlayerData playerData = new PlayerData();
        playerData.data = nbt.method_10562(DAT_FILE);
        return playerData;
    }

    public static class_18.class_8645<PlayerData> dataFactory() {
        return new class_18.class_8645(PlayerData::load, PlayerData::load, class_4284.field_19216);
    }

    private static PlayerData load() {
        return new PlayerData();
    }

    public Player getPlayer(class_3222 serverPlayer) {
        String uuid = serverPlayer.method_5845();
        Player player = this.playerMap.get(uuid);
        if (player == null) {
            class_2487 playterTag;
            DataResult result;
            if (this.data.method_10545(uuid) && (result = CODEC.parse((DynamicOps)class_2509.field_11560, (Object)(playterTag = this.data.method_10562(uuid)))).result().isPresent()) {
                Player playerData = (Player)result.result().get();
                this.playerMap.put(uuid, playerData);
                return playerData;
            }
            player = new Player(uuid);
            DataResult result2 = CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)player);
            this.data.method_10566(uuid, (class_2520)result2.result().get());
            this.playerMap.put(uuid, player);
        }
        return player;
    }

    public static class Player {
        private boolean hiddenUnderground;
        private boolean visible;
        private boolean chunkEntity;
        private boolean chunkFull;
        private boolean chunkBlock;
        private boolean chunkInaccessible;
        private final String uuid;

        public Player(String uuid) {
            this(uuid, false, true, false, false, false, false);
        }

        public Player(String uuid, boolean hiddenUnderground, boolean visible, boolean chunkEntity, boolean chunkFull, boolean chunkBlock, boolean chunkInaccessible) {
            this.uuid = uuid;
            this.hiddenUnderground = hiddenUnderground;
            this.visible = visible;
            this.chunkEntity = chunkEntity;
            this.chunkFull = chunkFull;
            this.chunkBlock = chunkBlock;
            this.chunkInaccessible = chunkInaccessible;
        }

        public String getUuid() {
            return this.uuid;
        }

        public boolean isHiddenUnderground() {
            return this.hiddenUnderground;
        }

        public void setHiddenUnderground(boolean hiddenUnderground) {
            this.hiddenUnderground = hiddenUnderground;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public boolean isChunkEntity() {
            return this.chunkEntity;
        }

        public void setChunkEntity(boolean chunkEntity) {
            this.chunkEntity = chunkEntity;
        }

        public boolean isChunkFull() {
            return this.chunkFull;
        }

        public void setChunkFull(boolean chunkFull) {
            this.chunkFull = chunkFull;
        }

        public boolean isChunkBlock() {
            return this.chunkBlock;
        }

        public void setChunkBlock(boolean chunkBlock) {
            this.chunkBlock = chunkBlock;
        }

        public boolean isChunkInaccessible() {
            return this.chunkInaccessible;
        }

        public void setChunkInaccessible(boolean chunkInaccessible) {
            this.chunkInaccessible = chunkInaccessible;
        }

        public boolean viewChunkEntity() {
            class_3222 player = Services.COMMON_SERVICE.getServer().method_3760().method_14602(UUID.fromString(this.uuid));
            return this.chunkEntity && PermissionsManager.getInstance().canServerAdmin(player);
        }

        public boolean viewChunkFull() {
            class_3222 player = Services.COMMON_SERVICE.getServer().method_3760().method_14602(UUID.fromString(this.uuid));
            return this.chunkFull && PermissionsManager.getInstance().canServerAdmin(player);
        }

        public boolean viewChunkBlock() {
            class_3222 player = Services.COMMON_SERVICE.getServer().method_3760().method_14602(UUID.fromString(this.uuid));
            return this.chunkBlock && PermissionsManager.getInstance().canServerAdmin(player);
        }

        public boolean viewChunkInaccessible() {
            class_3222 player = Services.COMMON_SERVICE.getServer().method_3760().method_14602(UUID.fromString(this.uuid));
            return this.chunkInaccessible && PermissionsManager.getInstance().canServerAdmin(player);
        }
    }
}

