/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.dispatch;

import commonnetwork.api.NetworkHandler;
import journeymap.client.InternalStateHandler;
import journeymap.client.JourneymapClient;
import journeymap.common.network.packets.ClientPermissionsPacket;
import journeymap.common.network.packets.HandshakePacket;
import journeymap.common.network.packets.MultiplayerOptionsPacket;
import journeymap.common.network.packets.ServerAdminRequestPropPacket;
import journeymap.common.network.packets.ServerAdminSavePropPacket;
import journeymap.common.network.packets.TeleportPacket;
import journeymap.common.network.packets.WorldIdPacket;

public class ClientNetworkDispatcher {
    protected final NetworkHandler handler;
    private final InternalStateHandler stateHandler;

    public ClientNetworkDispatcher(NetworkHandler handler) {
        this.handler = handler;
        this.stateHandler = JourneymapClient.getInstance().getStateHandler();
    }

    public void sendTeleportPacket(double x, int y, double z, String dim) {
        this.handler.sendToServer((Object)new TeleportPacket(x, y, z, dim), this.stateHandler.isJourneyMapServerConnection());
    }

    public void sendServerAdminScreenRequest(int id, String dim) {
        this.handler.sendToServer((Object)new ServerAdminRequestPropPacket(id, dim), this.stateHandler.isJourneyMapServerConnection());
    }

    public void sendSaveAdminDataPacket(int id, String payload, String dim) {
        this.handler.sendToServer((Object)new ServerAdminSavePropPacket(id, payload, dim), this.stateHandler.isJourneyMapServerConnection());
    }

    public void sendPermissionRequest() {
        this.handler.sendToServer((Object)new ClientPermissionsPacket(), this.stateHandler.isJourneyMapServerConnection());
    }

    public void sendWorldIdRequest() {
        this.handler.sendToServer((Object)new WorldIdPacket(), this.stateHandler.isJourneyMapServerConnection());
    }

    public void sendHandshakePacket(String version) {
        this.handler.sendToServer((Object)new HandshakePacket(version), this.stateHandler.isJourneyMapServerConnection());
    }

    public void sendMultiplayerOptionsRequest() {
        this.handler.sendToServer((Object)new MultiplayerOptionsPacket(), this.stateHandler.isJourneyMapServerConnection());
    }

    public void sendMultiplayerOptionsSaveRequest(String payload) {
        this.handler.sendToServer((Object)new MultiplayerOptionsPacket(payload), this.stateHandler.isJourneyMapServerConnection());
    }
}

