/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.UUID;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import journeymap.common.network.model.PlayerLocation;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class ServerPlayerLocationPacket
implements PlayerLocation {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"journeymap", (String)"player_loc");
    public static final class_9139<class_9129, ServerPlayerLocationPacket> STREAM_CODEC = class_9139.method_56438(ServerPlayerLocationPacket::encode, ServerPlayerLocationPacket::new);
    private int entityId;
    private UUID uniqueId;
    private double x;
    private double y;
    private double z;
    private byte yaw;
    private byte pitch;
    private boolean visible;

    public ServerPlayerLocationPacket() {
    }

    public ServerPlayerLocationPacket(class_1657 player, boolean visible) {
        this.uniqueId = player.method_7334().getId();
        this.visible = visible;
        if (visible) {
            this.entityId = player.method_5628();
            this.x = player.method_23317();
            this.y = player.method_23318();
            this.z = player.method_23321();
            this.yaw = (byte)(player.method_36454() * 256.0f / 360.0f);
            this.pitch = (byte)(player.method_36455() * 256.0f / 360.0f);
        }
    }

    public static class_8710.class_9154<class_8710> type() {
        return new class_8710.class_9154(CHANNEL);
    }

    public ServerPlayerLocationPacket(class_2540 buf) {
        try {
            if (buf.readableBytes() > 1) {
                this.visible = buf.readBoolean();
                this.uniqueId = buf.method_10790();
                if (this.visible) {
                    this.entityId = buf.method_10816();
                    this.x = buf.readDouble();
                    this.y = buf.readDouble();
                    this.z = buf.readDouble();
                    this.yaw = buf.readByte();
                    this.pitch = buf.readByte();
                }
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for player location request:" + String.valueOf(t));
        }
    }

    public void encode(class_2540 buf) {
        buf.method_52964(this.visible);
        buf.method_10797(this.uniqueId);
        if (this.visible) {
            buf.method_10804(this.entityId);
            buf.method_52940(this.x);
            buf.method_52940(this.y);
            buf.method_52940(this.z);
            buf.method_52997((int)this.yaw);
            buf.method_52997((int)this.pitch);
        }
    }

    public static void handle(PacketContext<ServerPlayerLocationPacket> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            JourneymapClient.getInstance().getPacketHandler().onPlayerLocationPacket((PlayerLocation)ctx.message());
        }
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public byte getYaw() {
        return this.yaw;
    }

    @Override
    public byte getPitch() {
        return this.pitch;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }
}

