/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.sysinfo.defaults;

import com.teamresourceful.resourcefullib.client.sysinfo.SystemInfo;
import com.teamresourceful.resourcefullib.client.sysinfo.SystemInfoBuilder;
import com.teamresourceful.resourcefullib.common.utils.modinfo.ModInfo;
import com.teamresourceful.resourcefullib.common.utils.modinfo.ModInfoUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_8144;
import net.minecraft.client.ClientBrandRetriever;

public record MinecraftInfo() implements Consumer<SystemInfoBuilder>
{
    private static final DecimalFormat DECIMAL_FORMAT = (DecimalFormat)class_156.method_654((Object)new DecimalFormat("########0.000"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));

    public static void register() {
        SystemInfo.addBuilder("Game", new MinecraftInfo());
    }

    private void tryAppendingFabric(SystemInfoBuilder builder) {
        if (ModInfoUtils.isModLoaded("fabric")) {
            ModInfo info = ModInfoUtils.getModInfo("fabric");
            builder.append("Mod Loader", info.displayName());
            builder.append("Fabric Version", info.version());
        }
    }

    private void tryAppendingQuilt(SystemInfoBuilder builder) {
        if (ModInfoUtils.isModLoaded("quilt")) {
            ModInfo info = ModInfoUtils.getModInfo("quilt");
            builder.append("Mod Loader", info.displayName());
            builder.append("Quilt Version", info.version());
        }
    }

    private void tryAppendingForge(SystemInfoBuilder builder) {
        if (ModInfoUtils.isModLoaded("forge")) {
            ModInfo info = ModInfoUtils.getModInfo("forge");
            builder.append("Mod Loader", info.displayName());
            builder.append("Forge Version", info.version());
        }
    }

    private void tryAppendingNeoForge(SystemInfoBuilder builder) {
        if (ModInfoUtils.isModLoaded("neoforge")) {
            ModInfo info = ModInfoUtils.getModInfo("neoforge");
            builder.append("Mod Loader", info.displayName());
            builder.append("NeoForge Version", info.version());
        }
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    @Override
    public void accept(SystemInfoBuilder builder) {
        class_310 mc = class_310.method_1551();
        builder.append("Minecraft Version", class_155.method_16673().method_48019());
        builder.append("Client Brand", ClientBrandRetriever.getClientModName());
        builder.append("Language", mc.method_1526().method_4669());
        this.tryAppendingFabric(builder);
        this.tryAppendingQuilt(builder);
        this.tryAppendingForge(builder);
        this.tryAppendingNeoForge(builder);
        builder.append("FPS", class_310.method_1551().method_47599());
        builder.append("TPS", class_8144.method_49078((Object)mc.method_1576(), server -> DECIMAL_FORMAT.format(Math.min(1000.0 / ((double)MinecraftInfo.mean(server.method_54835()) * 1.0E-6), 20.0)), (Object)"N/A"));
        builder.append("Ping", class_8144.method_49078((Object)mc.method_1562(), connection -> (String)class_8144.method_49078((Object)connection.method_45734(), data -> String.valueOf(data.field_3758), (Object)"No Server Data"), (Object)"N/A"));
        builder.append("Connection", mc.method_47392() ? "Singleplayer" : (mc.method_1542() ? "Singleplayer Lan" : "Multiplayer"));
        builder.append("Loaded Mods", ModInfoUtils.getLoadedMods());
    }
}

